<img src="files/refinitiv.png" width="20%" style="vertical-align: top;">

# Data Library for Python

## Summary

This repository provides a series examples that demonstrate how to programmatically access content residing within the **Refinitiv Data Platform (RDP)** using a single, ease of use software library called the **Refinitiv Data Library for Python**. This library is supported and maintained by Refinitiv and is available on PyPi at https://pypi.org/project/refinitiv-data/

The series of examples have been organized as follows:

### **Quick Start**

The *Quick Start* example focuses on choosing the correct session type (Platform/Desktop/Deployed) and establishing a connection to validate your credentials/connectivity parameters. This example should be used in conjunction with the [Quick Start guide](https://developers.refinitiv.com/en/api-catalog/refinitiv-data-platform/refinitiv-data-library-for-python/quick-start) available on the Refinitiv Developer Portal.


### **Tutorials**

The Tutorials section provides a set of basic examples that walk you through the some layers of the library and show how to retrieve content sets using the Refinitiv Data Library. These examples should be used in conjunction with the [Tutorials](https://developers.refinitiv.com/en/api-catalog/refinitiv-data-platform/refinitiv-data-library-for-python/tutorials) available on the Refinitiv Developer Portal.


### **Examples**

This section contains additional [examples](./Examples/README.md) to supplement the quick start guide and tutorials presented above. These simple and self explanatory examples will give you an overview of the different features and content sets available through the Refinitiv Data Library. 

### **Configuration**

This folder contains the configuration file of the Refinitiv Data Library for Python. Before running any of the examples described above, you must modify this file depending on the access channel and connection parameters that you will use to connect to the Refinitiv Data Platform. This necessary configuration step is explained in the [Quick Start guide](https://developers.refinitiv.com/en/api-catalog/refinitiv-data-platform/refinitiv-data-library-for-python/quick-start) 

## Learn more

To learn more about the Refinitiv Data Library for Python simply log into the Refinitiv Developer Community. By [registering](https://developers.refinitiv.com/iam/register) and [logging in](https://developers.refinitiv.com/content/devportal/en_us/initCookie.html) to the Refinitiv Developer Community portal you will have free access to a number of learning materials such as [Quick Start guides](https://developers.refinitiv.com/en/api-catalog/refinitiv-data-platform/refinitiv-data-library-for-python/quick-start), [Tutorials](https://developers.refinitiv.com/en/api-catalog/refinitiv-data-platform/refinitiv-data-library-for-python/tutorials), [Documentation](https://developers.refinitiv.com/en/api-catalog/refinitiv-data-platform/refinitiv-data-library-for-python/documentation) and much more.

## Help and Support

If you have any questions regarding using the API, please post them on the [Refinitiv Data Q&A Forum](https://community.developers.refinitiv.com/spaces/321/index.html). The Refinitiv Developer Community will be very pleased to help you.

