# This sample tests variance inference for traditional type variables.

from typing import Generic, Iterator, Sequence
from typing_extensions import TypeVar

T = TypeVar("T", infer_variance=True)
K = TypeVar("K", infer_variance=True)
V = TypeVar("V", infer_variance=True)

# This should generate an error because covariant cannot be used
# with infer_variance.
S1 = TypeVar("S1", covariant=True, infer_variance=True)

# This should generate an error because contravariant cannot be used
# with infer_variance.
S2 = TypeVar("S2", contravariant=True, infer_variance=True)


class ShouldBeCovariant1(Generic[T]):
    def __getitem__(self, index: int) -> T: ...
    def __iter__(self) -> Iterator[T]: ...


vco1_1: ShouldBeCovariant1[float] = ShouldBeCovariant1[int]()

# This should generate an error based on variance
vco1_2: ShouldBeCovariant1[int] = ShouldBeCovariant1[float]()


class ShouldBeCovariant2(Sequence[T]):
    pass

vco2_1: ShouldBeCovariant2[float] = ShouldBeCovariant2[int]()

# This should generate an error based on variance
vco2_2: ShouldBeCovariant2[int] = ShouldBeCovariant2[float]()



class ShouldBeInvariant1(Generic[T]):
    def __init__(self, value: T) -> None:
        self._value = value

    @property
    def value(self):
        return self._value

# This should generate an error based on variance
vinv1_1: ShouldBeInvariant1[float] = ShouldBeInvariant1[int](1)

# This should generate an error based on variance
vinv1_2: ShouldBeInvariant1[int] = ShouldBeInvariant1[float](1.1)


class ShouldBeInvariant2(Generic[T]):
    def __init__(self, value: T) -> None:
        self._value = value

    def get_value(self) ->T:
        return self._value

# This should generate an error based on variance
vinv2_1: ShouldBeInvariant2[float] = ShouldBeInvariant2[int](1)

# This should generate an error based on variance
vinv2_2: ShouldBeInvariant2[int] = ShouldBeInvariant2[float](1.1)


class ShouldBeInvariant3(dict[K, V]):
    pass

# This should generate an error based on variance
vinv3_1: ShouldBeInvariant3[float, str] = ShouldBeInvariant3[int, str]()

# This should generate an error based on variance
vinv3_2: ShouldBeInvariant3[int, str] = ShouldBeInvariant3[float, str]()

# This should generate an error based on variance
vinv3_3: ShouldBeInvariant3[str, float] = ShouldBeInvariant3[str, int]()

# This should generate an error based on variance
vinv3_4: ShouldBeInvariant3[str, int] = ShouldBeInvariant3[str, float]()


class ShouldBeContravariant1(Generic[T]):
    def __init__(self, value: T) -> None:
        self._value = value


# This should generate an error based on variance
vcontra1_1: ShouldBeContravariant1[float] = ShouldBeContravariant1[int](1)

vcontra1_2: ShouldBeContravariant1[int] = ShouldBeContravariant1[float](1.2)
