/// <reference path="fourslash.ts" />

// @filename: pyrightconfig.json
//// {
////   "reportMissingTypeStubs": "warning"
//// }

// @filename: testLib/mylibrary.py
// @library: true
//// # This is a library file
//// class MyLibrary:
////     def DoEveryThing(self, code: str):
////         ...
//// class ExceptLibrary:
////     def DoEveryThing(self, code: str):
////         ...
//// class ElseLibrary:
////     def DoEveryThing(self, code: str):
////         ...

// @filename: testLib/__init__.py
// @library: true
//// try:
////     from .mylibrary import MyLibrary
//// except:
////     from .mylibrary import ExceptLibrary
//// else:
////     from .mylibrary import ElseLibrary

// @filename: test.py
//// import [|/*marker*/testLi|]b

const filename4 = helper.getMarkerByName('marker').fileName;
const command4 = {
    title: 'Create Type Stub',
    command: Consts.Commands.createTypeStub,
    arguments: ['/', 'testLib', filename4],
};

// @ts-ignore
await helper.verifyCommand(command4, {
    ['/typings/testLib/__init__.pyi']: `"""
This type stub file was generated by pyright.
"""

from .mylibrary import MyLibrary

`,
});
