/// <reference path="fourslash.ts" />

// @filename: pyrightconfig.json
//// {
////   "reportMissingTypeStubs": "warning"
//// }

// @filename: testLib/__init__.py
// @library: true
//// # This is a library file
//// class MyLibrary:
////     def DoEveryThing(self, code: str):
////         ...

// @filename: test.py
//// import [|/*marker*/testLi|]b

const filename1 = helper.getMarkerByName('marker').fileName;
const command1 = {
    title: 'Create Type Stub',
    command: Consts.Commands.createTypeStub,
    arguments: ['/', 'testLib', filename1],
};

// @ts-ignore
await helper.verifyCommand(command1, {
    ['/typings/testLib/__init__.pyi']: `"""
This type stub file was generated by pyright.
"""

class MyLibrary:
    def DoEveryThing(self, code: str): # -> None:
        ...
    


`,
});
