/// <reference path="fourslash.ts" />

// @filename: pyrightconfig.json
//// {
////   "reportMissingTypeStubs": "warning"
//// }

// @filename: testLib.py
// @library: true
//// # This is a library file
//// class MyLibrary:
////     def DoEveryThing(self, code: str):
////         ...

// @filename: test.py
//// import [|/*marker*/testLi|]b

const filename3 = helper.getMarkerByName('marker').fileName;
const command3 = {
    title: 'Create Type Stub',
    command: Consts.Commands.createTypeStub,
    arguments: ['/', 'testLib', filename3],
};

// @ts-ignore
await helper.verifyCommand(command3, {
    ['/typings/testLib/__init__.pyi']: `"""
This type stub file was generated by pyright.
"""

class MyLibrary:
    def DoEveryThing(self, code: str): # -> None:
        ...
    


`,
});
