/// <reference path="fourslash.ts" />

// @filename: pyrightconfig.json
//// {
////   "reportMissingTypeStubs": "warning"
//// }

// @filename: testLib/aa/bb/__init__.py
// @library: true
//// # This is a library file
//// class MyLibrary:
////     def DoEveryThing(self, code: str):
////         ...

// @filename: testLib/aa/bb/cc.py
// @library: true
//// MyAlias = int

// @filename: test.py
//// import [|/*marker*/testLib.aa.b|]b

const filename2 = helper.getMarkerByName('marker').fileName;
const command2 = {
    title: 'Create Type Stub',
    command: Consts.Commands.createTypeStub,
    arguments: ['/', 'testLib.aa.bb', filename2],
};

// @ts-ignore
await helper.verifyCommand(command2, {
    ['/typings/testLib/aa/bb/__init__.pyi']: `"""
This type stub file was generated by pyright.
"""

class MyLibrary:
    def DoEveryThing(self, code: str): # -> None:
        ...
    


`,
    ['/typings/testLib/aa/bb/cc.pyi']: `"""
This type stub file was generated by pyright.
"""

MyAlias = int
`,
});
