[目录](index.md)

* [基本用法](1.usage.md)
* [选项](2.options.md)
* [界面操控](3.operation.md)
* [实验性功能](experimental-features.md)
  * [截图 (导出图片)](plugin-screenshot.md)
* [参与贡献](4.contribution.md)
* [贡献代码指南 *](5.development.md)


> 首先向您表示感谢，开源社区因为有您而生机勃勃，jsMind也因您而有了更大的价值。

基本流程
===

向 jsMind 贡献代码的基本流程是：

1. fork jsmind
2. 开发新功能或改进当前版本
3. 测试您的代码
4. 给 jsmind 提交 pull-request
5. 等待审查，审查期间可能会请你对您的代码进行修改
6. 合并你的 pull-request 到 jsMind 项目中

开发前的准备
===

**Pull-Request 及 Fork** : 阅读 github [pull-request 文档](https://docs.github.com/cn/pull-requests)， 了解如何通过 fork 及 pull-request 提交你的代码。

**Node.js** : 项目中使用 jsMind 并不依赖 Node.js 环境，但是在开发时，我们需要在 Node.js 环境下执行单元测试、代码格式化检查、及打包和压缩。jsMind 的 CI 环境里使用的 Node 版本是 18.x。

**Visual Studio Code** : 如果您使用的 IDE 是 VS Code, 建议您安装这个插件: `esbenp.prettier-vscode` 。这样你的 VS Code 将能自动按 jsMind 的配置对代码进行格式化。

开发
===

jsMind 使用 ES6 编写，代码在 `/src` 目录里，一般情况下只需要改动此目录里的代码。

开发过程中请记得随时格式化代码。在命令行中执行以下代码即可对代码进行格式化：
```
npm run format
```

单元测试
===

单元测试的代码位于 `/tests/unit` 目录，请为新代码的代码补充单元测试，并确保所有的单元测试都能通过。

在命令行中执行以下命令即可运行单元测试。
```
npm run test-es6
```

打包及压缩
===

在命令行中执行以下命令将代码打包为便于在浏览器中执行的js文件:
```
npm run build
```
生成的代码位于 `/es6` 目录。

本地预览及调试
===
在命令行中执行以下命令可以在本机启动一个简易的 http server
```
npm run server
```
执行后会提示 http server 的访问地址，一般情况下应该是 http://127.0.0.1:8080 。这时访问 http://127.0.0.1:8080/example/2_features_es6.html 即可在本地进行调试。

无论开发新功能还是修复bug, 都建议把页面上所有的用例全部测试一遍。

需要提醒的是，调试过程中如果修改了 js 文件，请重新执行打包命令 `npm run build` 并刷新页面才能查看到新的效果。

版权声明
===

禁止转载、禁止演绎。

jsMind 项目仍在不断升级变化，版本更新时会同时更新对应的文档。为避免给使用者带来困惑，在没有得到书面许可前，禁止转载本文档，同时禁止对本文档进行任何形式的更改。
