[目录](index.md)

* [基本用法](1.usage.md)
* [选项](2.options.md)
* [界面操控 *](3.operation.md)
* [实验性功能](experimental-features.md)
  * [截图 (导出图片)](plugin-screenshot.md)
* [参与贡献](4.contribution.md)
* [贡献代码指南](5.development.md)

jsMind 对象
===

jsMind 提供了对思维导图进行操控的一系列 API，这些 API 都是基于 `jsMind` 对象处理的，一般情况下可以使用下面的代码获取 jsMind 对象：

```javascript
/*
方法1：
    创建思维导图时即可获得 jsMind 对象
*/
var jm = new jsMind(options);

/*
方法2：
    当前页面已存在一个思维导图时可直接获得此 jsMind 对象
    当在一个页面里创建了多个 jsMind 时，此方法获得的是最后创建的那个对象
*/
var jm = jsMind.current;
```

节点对象
===

思维导图是由多个节点和节点之间的连线组成的，一个思维导图有一个根节点，根节点外围可以有多个子节点，子节点还可以有多个子节点。每个节点包含以下的多个属性：

```javascript
node {
    id,        //  : string                    节点id
    index,     //  : integer                   节点序号
    topic,     //  : string                    节点主题
    isroot,    //  : boolean                   指示该节点是否为根节点
    parent,    //  : node                      该节点的父节点，根节点的父节目为 null ，但请不要根据此属性判断该节点是否为根节点
    direction, //  : enum(left,center,right)   该节点的分布位置
    children,  //  : array of node             该节点的子节点组合
    expanded,  //  : boolean                   该节点的下级节点是否展开
    data,      //  : object{string: object}     该节点的其它附加数据
}
```

3.1. 显示思维导图
===

使用 `jm.show(mind)` 方法即可显示思维导图了，具体的用法请参见 [1.1. 基本框架](1.usage.md)

3.2. 查找节点
===

**获取根节点** : 使用 `jm.get_root()` 即可获取当前思维导图的根节点。

**根据 id 查找节点** : 使用 `jm.get_node(node_id)` 方法即可根据 id 查找当前思维导图中指定的节点，如果查找不到则返回 `null`。

**获取选中的节点** : 使用 `jm.get_selected_node()` 方法即可获取当前选中的节点，如果没有选中的节点则返回 `null`。

**查找相邻的节点** : 使用 `jm.find_node_before(node|node_id)` 和 `find_node_after(node|node_id)` 即可获取指定的节点的上一个或下一个节点，如果没有上一个或下一个，则返回 `null`。

**获取父节点** : 使用 `node.parent` 即可获取父节点，根节点的父节点为 `null`。

**获取子节点集合** : 使用 `node.children` 即可获取子节点的集合。

3.3. 操作节点
===

**选中节点** : 使用 `jm.select_node(node)` 方法选中指定的节点。
- `node`: 此参数表示要选择的节点，可以是一个 node 对象，或者是 node 的 id;

**收起子节点** : 使用 `jm.collapse_node(node)` 方法可收起该节点的子节点。
- `node`: 此参数表示要收起的节点，可以是一个 node 对象，或者是 node 的 id;

**展开子节点** : 使用 `jm.expand_node(node)` 方法可展开该节点的子节点。
- `node`: 此参数表示要展开的节点，可以是一个 node 对象，或者是 node 的 id;

**收起或展开子节点** : 使用 `jm.toggle_node(node)` 方法可自动展开或收起子节点。
- `node`: 此参数表示要收起或展开的节点，可以是一个 node 对象，或者是 node 的 id;

**展开全部子节点** : 使用 `jm.expand_all()` 方法可展开全部子节点。

**展开至层级** : 使用 `jm.expand_to_depth(depth)` 方法可展开到指定层级。

**移动节点** : 使用 `jm.move_node(node, before_id, parent_id, direction)` 方法用于移动节点

- `node`: 此参数表示要移动的节点，可以是一个 node 对象，或者是 node 的 id;
- `before_id`: 此参数是一个节点的 id，表示移动的目标位置，node 将会移动到该节点的前面。此参数还有以下两种取值:
    - `_first_` 表示移动到所有兄弟节点的最前面
    - `_last_` 表示移动到所有兄弟节点的最后面
- `parent_id`: [可选参数] 此参数是一个节点的 id, 表示移动的目标位置的父节点的 id。如果不提供该参数，将默认为 `before_id` 对应节点的父节点;
- `direction`: [可选参数] 此参数主要用于二级节点的移动，可以把一个节点移动到根节点的左侧或右侧。如果被移动的不是二级节点，则此参数无效；如果不提供该参数，将会自动确定节点的方向。此参数的取值有两种:
    - `left`
    - `right`

**居中节点** : 使用 `jm.scroll_node_to_center(node)` 方法可将该节点滚动至思维导图的中心位置。 (0.6.2 及以上版本支持)

**启用编辑** : 使用 `jm.enable_edit()` 方法可启用对当前思维导图的编辑功能。

**禁止编辑** : 使用 `jm.disable_edit()` 方法可禁止对当前思维导图进行编辑。

**编辑节点** : 使用 `jm.begin_edit(node)` 方法可以将该节点调整为编辑状态。
- `node`: 此参数表示要编辑的节点，可以是一个 node 对象，或者是 node 的 id;

**停止编辑** : 使用 `jm.end_edit()` 方法可以将该节点调整为只读状态。

3.4. 编辑节点
===

**添加节点** : 使用 `jm.add_node(parent_node, node_id, topic, data, direction)` 方法可为`parent_node`添加一个子节点。`data` 和 `direction` 为可选参数。

**在指定位置前插入节点** : 使用 `jm.insert_node_before(node_before, node_id, topic, data, direction)` 方法可在 `node_before` 节点前插入节点。`data` 和 `direction` 为可选参数。

**在指定位置后插入节点** : 使用 `jm.insert_node_after(node_after, node_id, topic, data, direction)` 方法可在 `node_after` 节点后插入节点。`data` 和 `direction` 为可选参数。

**删除节点** : 使用 `jm.remove_node(node|node_id)` 方法可删除指定的节点及其所有的子节点。

**更新节点** : 使用 `jm.update_node(node_id, topic)` 方法可更新指定节点的 topic，其它属性由于不在界面上显示，可以直接修改对应 node 的属性。

3.5. 设置样式
===

**设置主题** : 使用 `jm.set_theme(theme)` 方法可设置当前思维导图的主题。

**设置背景色/前景色** : 使用 `jm.set_node_color(node_id, bg_color, fg_color)` 方法可设置指定节点的背景色与前景色。

**设置字体** : 使用 `jm.set_node_font_style(node_id, size, weight, style)` 方法可设置指定节点的字体。

**设置背景图片** : 使用 `jm.set_node_background_image(node_id, image, width, height)` 方法可设置指定节点的背景图片。

3.6. 获取数据
===

**获取元数据** : 使用 `jm.get_meta()` 方法可获取当前思维导图的元数据。

**获取数据** : 使用 `jm.get_data(data_format)` 方法可获取当前思维导图的指定格式的数据文本。

3.7. 其它操作
===

**清除节点的选中** : 使用 `jm.select_clear()` 方法可以清除当前的选中状态。

**判断节点是否可见** : 使用 `jm.is_node_visible(node)` 方法可以判断此节点是否显示。

3.8. 兼容性说明
===

请尽量只使用此文档中介绍的这些 API, 在后续的版本迭代中，这些 API 将会得到最大程度的兼容性支持。此文档以外的方法有可能会随时修改和删除。

版权声明
===

禁止转载、禁止演绎。

jsMind 项目仍在不断升级变化，版本更新时会同时更新对应的文档。为避免给使用者带来困惑，在没有得到书面许可前，禁止转载本文档，同时禁止对本文档进行任何形式的更改。
