# Changelog

## [0.22.0](https://github.com/eslint/rewrite/compare/config-array-v0.21.1...config-array-v0.22.0) (2025-11-14)


### ⚠ BREAKING CHANGES

* Require Node.js ^20.19.0 || ^22.13.0 || >=24 ([#297](https://github.com/eslint/rewrite/issues/297))

### Features

* Require Node.js ^20.19.0 || ^22.13.0 || &gt;=24 ([#297](https://github.com/eslint/rewrite/issues/297)) ([acc623c](https://github.com/eslint/rewrite/commit/acc623c807bf8237a26b18291f04dd99e4e4981a))


### Dependencies

* The following workspace dependencies were updated
  * dependencies
    * @eslint/object-schema bumped from ^2.1.7 to ^3.0.0

## [0.21.1](https://github.com/eslint/rewrite/compare/config-array-v0.21.0...config-array-v0.21.1) (2025-10-17)


### Bug Fixes

* fix `config-array` and `object-schema` types ([#294](https://github.com/eslint/rewrite/issues/294)) ([a902bc4](https://github.com/eslint/rewrite/commit/a902bc4e27639ba5975b5d793314235737dc2c1a))


### Dependencies

* The following workspace dependencies were updated
  * dependencies
    * @eslint/object-schema bumped from ^2.1.6 to ^2.1.7

## [0.21.0](https://github.com/eslint/rewrite/compare/config-array-v0.20.1...config-array-v0.21.0) (2025-06-25)


### ⚠ BREAKING CHANGES

* Support `basePath` property in config objects ([#223](https://github.com/eslint/rewrite/issues/223))

### Features

* Support `basePath` property in config objects ([#223](https://github.com/eslint/rewrite/issues/223)) ([40d31ba](https://github.com/eslint/rewrite/commit/40d31ba42a9fe0da10b6ca5e1b10f1f2b10c5f90))

## [0.20.1](https://github.com/eslint/rewrite/compare/config-array-v0.20.0...config-array-v0.20.1) (2025-06-09)


### Bug Fixes

* consider negated patterns universal ([#220](https://github.com/eslint/rewrite/issues/220)) ([2dbe2b9](https://github.com/eslint/rewrite/commit/2dbe2b9c9431997bb4a1ab0335d8101564b62a41))
* explicit match in array elements of `files` ([#218](https://github.com/eslint/rewrite/issues/218)) ([e84cbd7](https://github.com/eslint/rewrite/commit/e84cbd7468765c25c01fc420b43d75a256533da2))

## [0.20.0](https://github.com/eslint/rewrite/compare/config-array-v0.19.2...config-array-v0.20.0) (2025-03-24)


### Features

* normalize patterns to handle "./" prefix in files and ignores ([#162](https://github.com/eslint/rewrite/issues/162)) ([bbbe909](https://github.com/eslint/rewrite/commit/bbbe9098fe112ca646947b83f71fbf5639f932e6))

## [0.19.2](https://github.com/eslint/rewrite/compare/config-array-v0.19.1...config-array-v0.19.2) (2025-01-31)


### Bug Fixes

* CommonJS types in all packages ([#148](https://github.com/eslint/rewrite/issues/148)) ([c91866c](https://github.com/eslint/rewrite/commit/c91866cc9fe16fb62bc48fc1cc7f9e18c6fea013))


### Dependencies

* The following workspace dependencies were updated
  * dependencies
    * @eslint/object-schema bumped from ^2.1.5 to ^2.1.6

## [0.19.1](https://github.com/eslint/rewrite/compare/config-array-v0.19.0...config-array-v0.19.1) (2024-12-04)


### Bug Fixes

* Update RuleVisitor type ([#135](https://github.com/eslint/rewrite/issues/135)) ([156d601](https://github.com/eslint/rewrite/commit/156d601181deb362a2864c4d47d4e3da8609500b))


### Dependencies

* The following workspace dependencies were updated
  * dependencies
    * @eslint/object-schema bumped from ^2.1.4 to ^2.1.5

## [0.19.0](https://github.com/eslint/rewrite/compare/config-array-v0.18.0...config-array-v0.19.0) (2024-10-25)


### ⚠ BREAKING CHANGES

* correctly detect if file is outside base path on Windows ([#59](https://github.com/eslint/rewrite/issues/59))

### Bug Fixes

* correctly detect if file is outside base path on Windows ([#59](https://github.com/eslint/rewrite/issues/59)) ([f93aa4c](https://github.com/eslint/rewrite/commit/f93aa4ca0a9a68b5c90847cd3d24801196abb405))

## [0.18.0](https://github.com/eslint/rewrite/compare/config-array-v0.17.1...config-array-v0.18.0) (2024-08-12)


### Features

* Export ObjectSchema ([#101](https://github.com/eslint/rewrite/issues/101)) ([f149f85](https://github.com/eslint/rewrite/commit/f149f855e81d4ba798a48873c9ab780bf8a0ac3a))

## [0.17.1](https://github.com/eslint/rewrite/compare/config-array-v0.17.0...config-array-v0.17.1) (2024-07-22)


### Bug Fixes

* `basePath` directory can never be ignored ([#92](https://github.com/eslint/rewrite/issues/92)) ([c94ab2d](https://github.com/eslint/rewrite/commit/c94ab2dea6410698a4b6814f921b39774b0e56ab))

## [0.17.0](https://github.com/eslint/rewrite/compare/config-array-v0.16.0...config-array-v0.17.0) (2024-06-26)


### ⚠ BREAKING CHANGES

* Allow escaping characters on Windows ([#61](https://github.com/eslint/rewrite/issues/61))

### Bug Fixes

* Allow escaping characters on Windows ([#61](https://github.com/eslint/rewrite/issues/61)) ([8501890](https://github.com/eslint/rewrite/commit/85018903815908bcfd940bbda347f3f17663e4bd))

## [0.16.0](https://github.com/eslint/rewrite/compare/config-array-v0.15.1...config-array-v0.16.0) (2024-06-12)


### ⚠ BREAKING CHANGES

* treat `*` as a universal pattern ([#50](https://github.com/eslint/rewrite/issues/50))
* Remove `ConfigArray#isExplicitMatch()` ([#53](https://github.com/eslint/rewrite/issues/53))

### Features

* Remove `ConfigArray#isExplicitMatch()` ([#53](https://github.com/eslint/rewrite/issues/53)) ([10d8200](https://github.com/eslint/rewrite/commit/10d8200fbc99ae4496fc308af82930bb41aeacfa))


### Bug Fixes

* Add 'main' and 'types' entries to package.json ([#48](https://github.com/eslint/rewrite/issues/48)) ([16ee1fa](https://github.com/eslint/rewrite/commit/16ee1fad998cc654208628ccb06958d29f95a3a5))
* treat `*` as a universal pattern ([#50](https://github.com/eslint/rewrite/issues/50)) ([79ad4bc](https://github.com/eslint/rewrite/commit/79ad4bcd09f73e66168ee3936c3c260af2c9953a))


### Dependencies

* The following workspace dependencies were updated
  * dependencies
    * @eslint/object-schema bumped from ^2.1.3 to ^2.1.4

## [0.15.1](https://github.com/eslint/rewrite/compare/config-array-v0.15.0...config-array-v0.15.1) (2024-05-30)


### Bug Fixes

* Update and standardize READMEs ([#33](https://github.com/eslint/rewrite/issues/33)) ([75521f7](https://github.com/eslint/rewrite/commit/75521f7d2e4aac9e77310803e7569d9d5b39869c))


### Dependencies

* The following workspace dependencies were updated
  * dependencies
    * @eslint/object-schema bumped from ^2.1.2 to ^2.1.3

## [0.15.0](https://github.com/eslint/rewrite/compare/config-array-v0.14.1...config-array-v0.15.0) (2024-05-30)


### ⚠ BREAKING CHANGES

* add method `getConfigStatus`, update `isFileIgnored` ([#7](https://github.com/eslint/rewrite/issues/7))

### Features

* add method `getConfigStatus`, update `isFileIgnored` ([#7](https://github.com/eslint/rewrite/issues/7)) ([400c5f9](https://github.com/eslint/rewrite/commit/400c5f92b7370f8ab6efd1b8dcd90ac1c1d04dd4))


### Bug Fixes

* ConfigObject type ([#27](https://github.com/eslint/rewrite/issues/27)) ([e42b15d](https://github.com/eslint/rewrite/commit/e42b15dc4a424030cac97582c0d500a76b13f328))
* npm and JSR package contents ([#16](https://github.com/eslint/rewrite/issues/16)) ([3e9eb67](https://github.com/eslint/rewrite/commit/3e9eb67964327ef908ab27fa0f14990580ec801c))


### Dependencies

* The following workspace dependencies were updated
  * dependencies
    * @eslint/object-schema bumped from ^2.1.1 to ^2.1.2

## [0.14.1](https://github.com/eslint/rewrite/compare/config-array-v0.14.0...config-array-v0.14.1) (2024-05-08)


### Bug Fixes

* Minor change to trigger new releases ([#13](https://github.com/eslint/rewrite/issues/13)) ([8184402](https://github.com/eslint/rewrite/commit/8184402d5efc8028380cbdd5669f600aea5c050a))


### Dependencies

* The following workspace dependencies were updated
  * dependencies
    * @eslint/object-schema bumped from ^2.1.0 to ^2.1.1

## [0.14.0](https://github.com/eslint/rewrite/compare/config-array-v0.13.0...config-array-v0.14.0) (2024-05-08)

### Features

* Add config-array package ([4a2274d](https://github.com/eslint/rewrite/commit/4a2274def58d1d41352b33f4e9c197d258fb5a36))
* Add types to config-array ([#3](https://github.com/eslint/rewrite/issues/3)) ([8b80e81](https://github.com/eslint/rewrite/commit/8b80e81cd0613ef1eccd15eacc0dbfad7a689dbf))
* sync packages meta ([#12](https://github.com/eslint/rewrite/issues/12)) ([27fcd25](https://github.com/eslint/rewrite/commit/27fcd259dab40e4ac1742b5699b74701a6b3660e))


### Bug Fixes

* Include package.json ([ce52aaa](https://github.com/eslint/rewrite/commit/ce52aaaec724ecf9dc9826efa680f6851b576357))


### Dependencies

* The following workspace dependencies were updated
  * dependencies
    * @eslint/object-schema bumped from ^2.0.3 to ^2.1.0

## [0.13.0](https://github.com/humanwhocodes/config-array/compare/v0.12.3...v0.13.0) (2024-04-17)


### Bug Fixes

* Throw friendly message for non-object configs ([#136](https://github.com/humanwhocodes/config-array/issues/136)) ([be918b6](https://github.com/humanwhocodes/config-array/commit/be918b6fa636a671a025354af7bbc69fa02842f7))
* Update release version for breaking change ([0b803d4](https://github.com/humanwhocodes/config-array/commit/0b803d41db6c93051f48b65325cb1b438c4b550b))


### Miscellaneous Chores

* Update release version ([5cacca6](https://github.com/humanwhocodes/config-array/commit/5cacca6e005bd27ea08e2f03692232f915d1a7bb))

## [0.12.3](https://github.com/humanwhocodes/config-array/compare/v0.12.2...v0.12.3) (2024-04-03)


### Bug Fixes

* don't match config with `ignores` and `name` only ([#133](https://github.com/humanwhocodes/config-array/issues/133)) ([3dabb4d](https://github.com/humanwhocodes/config-array/commit/3dabb4db2072a86d9b567205626ba0ed537bea2f))

## [0.12.2](https://github.com/humanwhocodes/config-array/compare/v0.12.1...v0.12.2) (2024-04-02)


### Bug Fixes

* ignore `name` field for global `ignores` ([#131](https://github.com/humanwhocodes/config-array/issues/131)) ([286f489](https://github.com/humanwhocodes/config-array/commit/286f48970f2b2c35c3fae14c5081d29ac23d11cc))

## [0.12.1](https://github.com/humanwhocodes/config-array/compare/v0.12.0...v0.12.1) (2024-04-01)


### Bug Fixes

* **deps:** Ensure unnecessary files are not packaged ([6c26fef](https://github.com/humanwhocodes/config-array/commit/6c26fef4f5367eeba48ff782e44f914b47e278bf))

## [0.12.0](https://github.com/humanwhocodes/config-array/compare/v0.11.14...v0.12.0) (2024-04-01)


### Features

* Report config name in error messages ([#128](https://github.com/humanwhocodes/config-array/issues/128)) ([58f8c9f](https://github.com/humanwhocodes/config-array/commit/58f8c9f8c06cbc6c67dfefe71b719bc6a940b7b3))

## [0.11.14](https://github.com/humanwhocodes/config-array/compare/v0.11.13...v0.11.14) (2024-01-10)


### Bug Fixes

* behavior of global `ignores` ([#126](https://github.com/humanwhocodes/config-array/issues/126)) ([9b3c72c](https://github.com/humanwhocodes/config-array/commit/9b3c72c67ff41f77ee7df549d95c4ca45b36d1ed))
* **deps:** Update object-schema ([8f0950a](https://github.com/humanwhocodes/config-array/commit/8f0950a253fd117e787e71f0c3bffe33942ce3a1))

## [0.11.13](https://github.com/humanwhocodes/config-array/compare/v0.11.12...v0.11.13) (2023-10-20)


### Bug Fixes

* **deps:** Upgrade object-schema to restore custom properties on errors ([d6d0b6a](https://github.com/humanwhocodes/config-array/commit/d6d0b6a415ef191ef9acd9169aec0827b86dcad3))

## [0.11.12](https://github.com/humanwhocodes/config-array/compare/v0.11.11...v0.11.12) (2023-10-19)


### Bug Fixes

* caching of ignored files ([#111](https://github.com/humanwhocodes/config-array/issues/111)) ([839d838](https://github.com/humanwhocodes/config-array/commit/839d838e607cf5fb69d1acd314d6bb7aa20bc042))

## [0.11.11](https://github.com/humanwhocodes/config-array/compare/v0.11.10...v0.11.11) (2023-08-29)


### Bug Fixes

* validate `files` and `ignores` elements ([#103](https://github.com/humanwhocodes/config-array/issues/103)) ([c40894f](https://github.com/humanwhocodes/config-array/commit/c40894ff86d1635c45649ac1f3c03a274e2529d9))

## [0.11.10](https://github.com/humanwhocodes/config-array/compare/v0.11.9...v0.11.10) (2023-06-01)


### Bug Fixes

* Allow directory-based ignores for files matches ([0163f31](https://github.com/humanwhocodes/config-array/commit/0163f313dbfe50d283042141dbad5958f9d5d2ad))
* Revert allow directory-based ignores for files matches ([322ad01](https://github.com/humanwhocodes/config-array/commit/322ad011b7d4761205ae7f85c8fdb58574dbf388))

## [0.11.9](https://github.com/humanwhocodes/config-array/compare/v0.11.8...v0.11.9) (2023-05-12)


### Bug Fixes

* Config with just ignores should not always be applied ([#89](https://github.com/humanwhocodes/config-array/issues/89)) ([5ed9c2c](https://github.com/humanwhocodes/config-array/commit/5ed9c2c1a13afb42cd7e9d3b1b247761cb7aa040))

## [0.11.8](https://github.com/humanwhocodes/config-array/compare/v0.11.7...v0.11.8) (2022-12-14)


### Bug Fixes

* Ensure gitignore-style directory ignores ([#74](https://github.com/humanwhocodes/config-array/issues/74)) ([8e17f4a](https://github.com/humanwhocodes/config-array/commit/8e17f4a7378cb0b417e1103d60ef397b26d2f917))

## [0.11.7](https://github.com/humanwhocodes/config-array/compare/v0.11.6...v0.11.7) (2022-10-28)


### Bug Fixes

* **deps:** Update minimatch to secure version ([3219294](https://github.com/humanwhocodes/config-array/commit/3219294bf9170c500ee9e212b59e17ef205b7c3c))

## [0.11.6](https://github.com/humanwhocodes/config-array/compare/v0.11.5...v0.11.6) (2022-10-21)


### Bug Fixes

* Only apply universal patterns if others match. ([e69c8fd](https://github.com/humanwhocodes/config-array/commit/e69c8fdbb7696b406821bc723b86b4c5304c4260))

## [0.11.5](https://github.com/humanwhocodes/config-array/compare/v0.11.4...v0.11.5) (2022-10-17)


### Bug Fixes

* Unignoring of directories should work ([e1c9dcd](https://github.com/humanwhocodes/config-array/commit/e1c9dcd05534619effe258596191ea9dc5bb37af))

## [0.11.4](https://github.com/humanwhocodes/config-array/compare/v0.11.3...v0.11.4) (2022-10-14)


### Bug Fixes

* Ensure subdirectories of ignored directories are ignored ([0df450e](https://github.com/humanwhocodes/config-array/commit/0df450eabeb595ae22fe680ce3320dc47edb1e66))

## [0.11.3](https://github.com/humanwhocodes/config-array/compare/v0.11.2...v0.11.3) (2022-10-13)


### Bug Fixes

* Ensure directories can be unignored. ([206404c](https://github.com/humanwhocodes/config-array/commit/206404c490d354a4f39ef9b4a6d0ceaec119abc5))

## [0.11.2](https://github.com/humanwhocodes/config-array/compare/v0.11.1...v0.11.2) (2022-10-03)


### Bug Fixes

* Error conditions for isDirectoryIgnored ([0bd81f5](https://github.com/humanwhocodes/config-array/commit/0bd81f53b7c217d561f70709057c7d77f17e8c6d))
* isDirectoryIgnored should match on relative path. ([3d1eaf6](https://github.com/humanwhocodes/config-array/commit/3d1eaf6389056215e27793cde9c2954c01c78df8))
* isFileIgnored should call isDirectoryIgnored ([270d359](https://github.com/humanwhocodes/config-array/commit/270d359295f376edb0c73905f62a848284d34053))


### Performance Improvements

* Cache isDirectoryIgnored calls ([c5e6720](https://github.com/humanwhocodes/config-array/commit/c5e67208618e253c08bd320efeae4b1f63641e63))

## [0.11.1](https://github.com/humanwhocodes/config-array/compare/v0.11.0...v0.11.1) (2022-09-30)


### Bug Fixes

* isDirectoryIgnored should not test negated patterns ([f6cdb68](https://github.com/humanwhocodes/config-array/commit/f6cdb688784901970fda72eb688eb1a00c44b09a))

## [0.11.0](https://github.com/humanwhocodes/config-array/compare/v0.10.7...v0.11.0) (2022-09-30)


### Features

* Add isDirectoryIgnored; deprecated isIgnored ([e6942f2](https://github.com/humanwhocodes/config-array/commit/e6942f2ce075007d39f23530593b7adb19178a52))

## [0.10.7](https://github.com/humanwhocodes/config-array/compare/v0.10.6...v0.10.7) (2022-09-29)


### Bug Fixes

* Cache negated patterns separately ([fef617b](https://github.com/humanwhocodes/config-array/commit/fef617b6999f9a4b5871d4525c82c4181bc96fb7))

## [0.10.6](https://github.com/humanwhocodes/config-array/compare/v0.10.5...v0.10.6) (2022-09-28)


### Performance Improvements

* Cache Minimatch instances ([5cf9af7](https://github.com/humanwhocodes/config-array/commit/5cf9af7ecaf227d2106be0cebd92d7f5148867e6))

## [0.10.5](https://github.com/humanwhocodes/config-array/compare/v0.10.4...v0.10.5) (2022-09-21)


### Bug Fixes

* Improve caching to improve performance ([#50](https://github.com/humanwhocodes/config-array/issues/50)) ([8a7e8ab](https://github.com/humanwhocodes/config-array/commit/8a7e8ab499bcbb10d7cbdd676197fc686966a64e))

### [0.10.4](https://www.github.com/humanwhocodes/config-array/compare/v0.10.3...v0.10.4) (2022-07-29)


### Bug Fixes

* Global ignores only when no other keys ([1f6b6ae](https://www.github.com/humanwhocodes/config-array/commit/1f6b6ae89152c1ebe118f55e7ea05c37e7c960dc))
* Re-introduce ignores fixes ([b3ec560](https://www.github.com/humanwhocodes/config-array/commit/b3ec560c485bec2f7420fd63a939448b49a073e3))

### [0.10.3](https://www.github.com/humanwhocodes/config-array/compare/v0.10.2...v0.10.3) (2022-07-20)


### Bug Fixes

* Ensure preprocess method has correct 'this' value. ([f86933a](https://www.github.com/humanwhocodes/config-array/commit/f86933a072e5a4069bab2c1ce284dedf0efa715d))

### [0.10.2](https://www.github.com/humanwhocodes/config-array/compare/v0.10.1...v0.10.2) (2022-03-18)


### Bug Fixes

* Files outside of basePath should be ignored ([fc4d7b2](https://www.github.com/humanwhocodes/config-array/commit/fc4d7b2e851959ab9ab84305f6c78c52e9cc2c3c))

### [0.10.1](https://www.github.com/humanwhocodes/config-array/compare/v0.10.0...v0.10.1) (2022-03-03)


### Bug Fixes

* Explicit matching is required against files field ([ab4e428](https://www.github.com/humanwhocodes/config-array/commit/ab4e4282ecea994ef88d273dc47aa24bf3c6972e))

## [0.10.0](https://www.github.com/humanwhocodes/config-array/compare/v0.9.5...v0.10.0) (2022-03-01)


### Features

* Add isExplicitMatch() method ([9ecd90e](https://www.github.com/humanwhocodes/config-array/commit/9ecd90e2a3e984633f535daa4da3cbfb96964fdd))

### [0.9.5](https://www.github.com/humanwhocodes/config-array/compare/v0.9.4...v0.9.5) (2022-02-23)


### Bug Fixes

* Ensure dot directories are matched correctly ([6e8d180](https://www.github.com/humanwhocodes/config-array/commit/6e8d180f43cedf3c2072d8a1229470e9fafabf5b))
* preprocessConfig should have correct 'this' value ([9641540](https://www.github.com/humanwhocodes/config-array/commit/96415402cf0012ccf8e4af6c7b934dfc1a058986))

### [0.9.4](https://www.github.com/humanwhocodes/config-array/compare/v0.9.3...v0.9.4) (2022-01-27)


### Bug Fixes

* Negated patterns to work when files match ([398c811](https://www.github.com/humanwhocodes/config-array/commit/398c8119d359493dc7b82b40df4d92ea6528375f))

### [0.9.3](https://www.github.com/humanwhocodes/config-array/compare/v0.9.2...v0.9.3) (2022-01-26)


### Bug Fixes

* Make negated ignore patterns work like gitignore ([4ee8e99](https://www.github.com/humanwhocodes/config-array/commit/4ee8e998436e2c4538b06476e0bead8a44fe5a1b))

### [0.9.2](https://www.github.com/humanwhocodes/config-array/compare/v0.9.1...v0.9.2) (2021-11-02)


### Bug Fixes

* Object merging error by upgrading object-schema ([377d06d](https://www.github.com/humanwhocodes/config-array/commit/377d06d2a44d781b0bec70b3389c48b3d5a63f94))

### [0.9.1](https://www.github.com/humanwhocodes/config-array/compare/v0.9.0...v0.9.1) (2021-10-05)


### Bug Fixes

* Properly build package for release ([168155f](https://www.github.com/humanwhocodes/config-array/commit/168155f3fed91ab35566c452efd28debf8ec2b85))

## [0.9.0](https://www.github.com/humanwhocodes/config-array/compare/v0.8.0...v0.9.0) (2021-10-04)


### Features

* getConfig() now returns undefined when no configs match. ([a563b82](https://www.github.com/humanwhocodes/config-array/commit/a563b8255d4eb2bb7745314e3f00ef53792b343f))

## [0.8.0](https://www.github.com/humanwhocodes/config-array/compare/v0.7.0...v0.8.0) (2021-10-01)


### Features

* Add isIgnored() method ([343e5a0](https://www.github.com/humanwhocodes/config-array/commit/343e5a0a9e32028bfc6c0bf1ec0c6badf74f47f9))


### Bug Fixes

* Ensure global ignores are honored ([343e5a0](https://www.github.com/humanwhocodes/config-array/commit/343e5a0a9e32028bfc6c0bf1ec0c6badf74f47f9))

## [0.7.0](https://www.github.com/humanwhocodes/config-array/compare/v0.6.0...v0.7.0) (2021-09-24)


### Features

* Only object configs by default ([5645f24](https://www.github.com/humanwhocodes/config-array/commit/5645f241b2412a3263a02ef9e3a9bd19cc86035d))

## [0.6.0](https://www.github.com/humanwhocodes/config-array/compare/v0.5.0...v0.6.0) (2021-04-20)


### Features

* Add the normalizeSync() method ([3e347f9](https://www.github.com/humanwhocodes/config-array/commit/3e347f9d77c5ca2b15995e75ff7bc4fb96b7d66e))
* Allow async config functions ([a9def0f](https://www.github.com/humanwhocodes/config-array/commit/a9def0faf579c223349dfe08d2486756840538c3))
