# ESLint Configuration Migrator

## Overview

This package aids in the migration of the legacy ESLint configuration file format (`.eslintrc.`) to the new ESLint configuration file format (`eslint.config.js`).

**Note:** The generated configuration file isn't guaranteed to work in all cases, but it should get you a lot closer to a working configuration file than manually trying to migrate.

## Limitations

This tool currently works well for the following config file formats:

- `.eslintrc`
- `.eslintrc.json`
- `.eslintrc.yml`

If you are using a JavaScript configuration file (`.eslintrc.js`, `.eslintrc.cjs`, `.eslintrc.mjs`), this tool currently is only capable of migrating the _evaluated_ configuration. That means any logic you may have inside of the file will be lost. If your configuration file is mostly static, then you'll get a good result; if your configuration file is more complex (using functions, calculating paths, etc.) then this tool will not provide an equivalent configuration file.

## Usage

You can run this package on the command line without installing it first by using `npx` or a similar tool:

```shell
npx @eslint/migrate-config .eslintrc.json
# or
bunx @eslint/migrate-config .eslintrc.json
```

The tool will automatically find your `.eslintignore` file in the same directory and migrate that into your new configuration file.

If you receive any npm errors while running using `npx`, install the package manually first:

```shell
npm i @eslint/migrate-config
npx @eslint/migrate-config .eslintrc.json
```

### CommonJS Output

By default, this tool generates an ESM file (`.mjs` extension). If you'd like to generate a CommonJS file instead, pass the `--commonjs` flag:

```shell
npx @eslint/migrate-config .eslintrc.json --commonjs
# or
bunx @eslint/migrate-config .eslintrc.json --commonjs
```

### Including a `.gitignore` file

If you are currently using `--ignore-path .gitignore` on the CLI, you'll need to read the `.gitignore` file into your config file. The migration can handle this for you by passing the `--gitignore` flag:

```shell
npx @eslint/migrate-config .eslintrc.json --gitignore
# or
bunx @eslint/migrate-config .eslintrc.json --gitignore
```

## Followup Steps

Once you have completed the migration, you may need to manually modify the resulting config file.

### Upgrade Plugins and Double-Check Compatibility

For any plugins used in your configuration file, make sure to upgrade to the latest version. Many plugins are creating their v9-compatible versions and this tool may be out-of-date in relation to which plugins fully support v9.

After upgrading, double-check if the plugin still needs any of the compatibility utilities that were autogenerated as part of the migration.

### `--ext`

If you are using `--ext` on the command line, such as:

```shell
npx eslint --ext .ts .
```

You'll need to remove the `--ext` from the command line and add an equivalent object into your configuration file. For example, `--ext .ts` requires an object like this in your configuration file:

```js
export default [
	{
		files: ["**/*.ts"],
	},

	// the rest of your config
];
```

This tells ESLint to search for all files ending with `.ts` when a directory is passed on the command line. You can choose to add additional properties to this object if you'd like, but it's not required.

## License

Apache 2.0

<!-- NOTE: This section is autogenerated. Do not manually edit.-->
<!--sponsorsstart-->

## Sponsors

The following companies, organizations, and individuals support ESLint's ongoing maintenance and development. [Become a Sponsor](https://eslint.org/donate)
to get your logo on our READMEs and [website](https://eslint.org/sponsors).

<h3>Platinum Sponsors</h3>
<p><a href="https://automattic.com"><img src="https://images.opencollective.com/automattic/d0ef3e1/logo.png" alt="Automattic" height="128"></a> <a href="https://www.airbnb.com/"><img src="https://images.opencollective.com/airbnb/d327d66/logo.png" alt="Airbnb" height="128"></a></p><h3>Gold Sponsors</h3>
<p><a href="https://qlty.sh/"><img src="https://images.opencollective.com/qltysh/33d157d/logo.png" alt="Qlty Software" height="96"></a> <a href="https://shopify.engineering/"><img src="https://avatars.githubusercontent.com/u/8085" alt="Shopify" height="96"></a></p><h3>Silver Sponsors</h3>
<p><a href="https://vite.dev/"><img src="https://images.opencollective.com/vite/e6d15e1/logo.png" alt="Vite" height="64"></a> <a href="https://liftoff.io/"><img src="https://images.opencollective.com/liftoff/2d6c3b6/logo.png" alt="Liftoff" height="64"></a> <a href="https://americanexpress.io"><img src="https://avatars.githubusercontent.com/u/3853301" alt="American Express" height="64"></a> <a href="https://stackblitz.com"><img src="https://avatars.githubusercontent.com/u/28635252" alt="StackBlitz" height="64"></a></p><h3>Bronze Sponsors</h3>
<p><a href="https://cybozu.co.jp/"><img src="https://images.opencollective.com/cybozu/933e46d/logo.png" alt="Cybozu" height="32"></a> <a href="https://syntax.fm"><img src="https://github.com/syntaxfm.png" alt="Syntax" height="32"></a> <a href="https://icons8.com/"><img src="https://images.opencollective.com/icons8/7fa1641/logo.png" alt="Icons8" height="32"></a> <a href="https://discord.com"><img src="https://images.opencollective.com/discordapp/f9645d9/logo.png" alt="Discord" height="32"></a> <a href="https://www.gitbook.com"><img src="https://avatars.githubusercontent.com/u/7111340" alt="GitBook" height="32"></a> <a href="https://nx.dev"><img src="https://avatars.githubusercontent.com/u/23692104" alt="Nx" height="32"></a> <a href="https://opensource.mercedes-benz.com/"><img src="https://avatars.githubusercontent.com/u/34240465" alt="Mercedes-Benz Group" height="32"></a> <a href="https://herocoders.com"><img src="https://avatars.githubusercontent.com/u/37549774" alt="HeroCoders" height="32"></a> <a href="https://www.lambdatest.com"><img src="https://avatars.githubusercontent.com/u/171592363" alt="LambdaTest" height="32"></a></p>
<h3>Technology Sponsors</h3>
Technology sponsors allow us to use their products and services for free as part of a contribution to the open source ecosystem and our work.
<p><a href="https://netlify.com"><img src="https://raw.githubusercontent.com/eslint/eslint.org/main/src/assets/images/techsponsors/netlify-icon.svg" alt="Netlify" height="32"></a> <a href="https://algolia.com"><img src="https://raw.githubusercontent.com/eslint/eslint.org/main/src/assets/images/techsponsors/algolia-icon.svg" alt="Algolia" height="32"></a> <a href="https://1password.com"><img src="https://raw.githubusercontent.com/eslint/eslint.org/main/src/assets/images/techsponsors/1password-icon.svg" alt="1Password" height="32"></a></p>
<!--sponsorsend-->
