# Use and Target ESM

Date: 2022-10-31

Status: accepted

## Context

ECMAScript Modules (ESM) have been a standard since 2015 and the move off of CommonJS is now well under way. Newer runtimes like Deno and Bun are ESM-only, most of web development is done in ESM.

For all of ESLint's history, packages have been written and published in CommonJS, only sometimes providing an ESM entrypoint.

## Decision

All packages in the rewrite repository will be written in ESM and preferentially provide ESM entrypoints (where applicable). When possible, the packages will provide CommonJS entrypoints as well.

## Consequences

We will not be dogfooding CommonJS-specific functionality in ESLint, so there is the possibility that some errors could creep in. We'll need to rely on our tests to catch these.
