from setuptools import setup
import io
import os
import re
import sys


def get_changelog():
    if 'bdist_rpm' in sys.argv:
        # exclude changelog when building rpm
        return ""
    here = os.path.abspath(".")
    text = io.open(os.path.join(here, 'CHANGELOG'), encoding='utf-8').read()
    header_matches = list(re.finditer('^=+$', text, re.MULTILINE))
    # until fifth header
    text = text[:header_matches[5].start()]
    # all lines without fifth release number
    lines = text.splitlines()[:-1]
    return "=========\nChangelog\n=========\n\n" + "\n".join(lines)


README = io.open(os.path.abspath('README.rst'), encoding='utf-8').read()
CHANGELOG = get_changelog()


setup(
    name="devpi-web",
    description="devpi-web: a web view for devpi-server",
    long_description="\n\n".join([README, CHANGELOG]),
    url="https://devpi.net",
    project_urls={
        'Bug Tracker': 'https://github.com/devpi/devpi/issues',
        'Changelog': 'https://github.com/devpi/devpi/blob/main/web/CHANGELOG',
        'Documentation': 'https://doc.devpi.net',
        'Source Code': 'https://github.com/devpi/devpi'
    },
    version='4.3.0',
    maintainer="Florian Schulze",
    maintainer_email="mail@pyfidelity.com",
    license="MIT",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Web Environment",
        "Intended Audience :: Developers",
        "Intended Audience :: System Administrators",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python",
        "Topic :: Internet :: WWW/HTTP",
        "Programming Language :: Python :: Implementation :: PyPy",
        "Topic :: Internet :: WWW/HTTP :: WSGI :: Application"] + [
            "Programming Language :: Python :: %s" % x
            for x in "3.4 3.5 3.6 3.7 3.8 3.9 3.10 3.11 3.12".split()],
    entry_points={
        'console_scripts': [
            "devpi-clear-search-index = devpi_web.clear_index:clear_index"],
        'devpi_server': [
            "devpi-web = devpi_web.main",
            "devpi-web-whoosh = devpi_web.whoosh_index"],
        'devpi_web': [
            "devpi-web-null = devpi_web.null_index",
            "devpi-web-whoosh = devpi_web.whoosh_index"]},
    install_requires=[
        'Whoosh<3',
        'beautifulsoup4>=4.3.2,!=4.12.1',
        'defusedxml',
        'devpi-server>=5.2.0',
        'devpi-common>=3.2.0',
        'docutils>=0.11',
        'py',
        'pygments>=1.6',
        'pyramid!=1.10a1',
        'pyramid-chameleon',
        'readme-renderer[md]>=23.0'],
    include_package_data=True,
    python_requires='>=3.4',
    zip_safe=False,
    packages=['devpi_web'])
