// Package shared provides common test data for benchmark consistency
package shared

// TestTexts contains sample text strings for benchmarking
var TestTexts = []string{
	"Él Múrcielago Rápido",
	"PROCESANDO textos LARGOS",
	"Optimización de MEMORIA",
	"Rendimiento en APLICACIONES",
	"Reducción de ASIGNACIONES",
	"Análisis de RENDIMIENTO",
	"Gestión de RECURSOS",
	"Eficiencia OPERACIONAL",
}

// TestNumbers contains sample numeric values for benchmarking
var TestNumbers = []float64{
	123456.789,
	987654.321,
	555555.555,
	111111.111,
	999999.999,
	777777.777,
	333333.333,
	888888.888,
}

// TestMixedData contains mixed data types for complex benchmarking scenarios
var TestMixedData = map[string]any{
	"Número": 12345.67,
	"Texto":  "Información IMPORTANTE",
	"Valor":  98765.43,
	"Título": "Análisis de RENDIMIENTO",
}
