## Vuex は何ですか？

Vuex は Vue.js アプリケーションで集中状態管理するためのアプリケーションアーキテクチャです。[Flux](https://facebook.github.io/flux/) や [Redux](https://github.com/rackt/redux) からインスピレーションを得ていますが、 簡易化された概念、そして Vue.js リアクティブシステムの長所を得るために、特別に設計された実装になっています。

## なぜこれを必要とするのですか？

あなたのアプリケーションが非常に単純であるならば、多分 Vuex は必要ないでしょう。それを早まって適用しないでください。しかし、中〜大規模な SPA を構築する場合は、あなたの Vue コンポーネントの外側でどうやってよりよい構造物にするかについて考える状況に遭遇する機会です。これは Vuex の出番です。

Vue.js を単独て使用するとき、しばしば、私達のコンポーネントの"内部"状態を保持します。つまり、各コンポーネントは、私達のアプリケーション状態の一部を所有しており、結果として状態があらゆる場所に散在しています。しかしながら、時どき状態の一部は、複数のコンポーネントにより共有される必要があります。一般的に見られる経験として、あるコンポーネントがいくつかの状態を他のコンポーネントにカスタムイベントシステムを使用して"送ろう"とします。このパターンの問題は、大規模なコンポーネントツリー内部のイベントフローはすぐに複雑にでき、しばしばうまく動作しない場合はそれについて原因を調査するのは難しいです。

大規模アプリケーションで状態を共有させるために優れた対処として、**コンポーネントのローカル状態**と**アプリケーションレベルの状態**を区別する必要があります。アプリケーション状態は特定のコンポーネントに属していませんが、私達のコンポーネントはリアクティブな DOM 更新のためにそれを監視できます。1 つの場所でそれを集中的に管理することによって、あるコンポーネントがそこに属する必要よりも全てに影響を与えるため、もはやイベントあちこちを渡す必要はありません。加えて、私達は、記録と状態変化の理解を容易にするための全ての変異を検査することができ、タイムトラベルデバッグのような派手なものも実装可能です。

Vuex はまた、どのように異なる場所に状態管理ロジックを分離するか、いくつか意見を強制しますが、それでも実際のコード構造に対して十分な柔軟性を可能します。
