## 什么是 Vuex?

Vuex 是一个专门为 Vue.js 应用所设计的集中式状态管理架构。它借鉴了 [Flux](https://facebook.github.io/flux/) 和 [Redux](https://github.com/rackt/redux) 的设计思想，但简化了概念，并且采用了一种为能更好发挥 Vue.js 数据响应机制而专门设计的实现。

## 我为什么需要它？

当你的应用还很简单的时候，你多半并不需要 Vuex。也不建议过早地使用 Vuex。但如果你正在构建一个中型以上规模的 SPA，你很有可能已经需要思考应该如何更好地归纳 Vue 之外，应用的其他组成部分。这就是 Vuex 要大显身手的时刻。

我们在单独使用 Vue.js 的时候，通常会把状态储存在组件的内部。也就是说，每一个组件都拥有当前应用状态的一部分，整个应用的状态是分散在各个角落的。然而我们经常会需要把状态的一部分共享给多个组件。一个常见的解决策略为：使用定制的事件系统，让一个组件把一些状态“*发送*”到其他组件中。这种模式的问题在于，大型组件树中的事件流会很快变得非常繁杂，并且调试时很难去找出究竟哪错了。

为了更好的解决在大型应用中状态的共用问题，我们需要对组件的 **组件本地状态**(component local state) 和 **应用层级状态**(application level state) 进行区分。应用级的状态不属于任何特定的组件，但每一个组件仍然可以监视(Observe)其变化从而响应式地更新 DOM。通过汇总应用的状态管理于一处，我们就不必到处传递事件。因为任何牵扯到一个以上组件的逻辑，都应该写在这里。此外，这样做也能让我们更容易地记录并观察状态的变更（Mutation，原意为突变），甚至可以实现出华丽如时光旅行一般的调试效果。（译注：是时候安利一波 [vue-devtools](https://github.com/vuejs/vue-devtools) 了）

Vuex 也对如何管理分撒各地的状态增加了一些约束，但仍保留有足够面对真实使用场景的灵活性。
