# ステート

### 単一ステートツリー

Vuex は**単一ステートツリー (single state tree)**を使用します。つまり、この単一なオブジェクトはあなたのアプリケーションレベルの状態が全て含まれており、"信頼できる唯一の情報源 (single source of truth)" として機能します。これは状態の特定の部分を見つけることが容易になり、そしてデバッギング目的のために現在のアプリケーション状態のスナップショットを取ることも容易にできます。

単一ステートツリーはモジュールとコンフリクト(競合)しません。以降の章では、あなたの状態管理ロジックをサブモジュールにおいてどうやって分離するかについて説明します。

### Vue コンポーネントにおいて Vuex ステートを取得する
`state` オブジェクトは、Vue インスタンスに渡される `data` オブジェクトに似ており、一度 Vuex store に渡され、[Vue のリアクティブシステム](http://vuejs.org/guide/reactivity.html) によってリアクティブになります。これは、Vue コンポーネントにバインディングする Vuex state は、算出プロパティ (computed property) の中からそれを返すのと同じくらい簡単なことを意味します:

``` js
// Vue コンポーネントモジュール内部

// vuex store をインポート
import store from './store'

export default {
  computed: {
    message () {
      return store.state.message
    }
  }
}
```

store にコンポーネントを設定し、そしてリスナを切断または"接続する"心配の必要はりません。覚えておくくべき唯一のことは、**常にあなたの算出プロパティ内部で `store.state.xxx` 経由でステートを参照する**必要があるということです。算出プロパティ外のステートの一部への参照をキャッシュしないでください。

> Flux リファレンス: これは雑ですが Redux での [`mapStateToProps`](https://github.com/rackt/react-redux/blob/master/docs/api.md#connectmapstatetoprops-mapdispatchtoprops-mergeprops-options) と NuclearJS での [getters](https://optimizely.github.io/nuclear-js/docs/04-getters.html) と比較することができます。

なぜ、ステートにバインドするために `data` を使用しないのでしょうか？次の例を考えてみます:

``` js
export default {
  data () {
    return {
      message: store.state.message
    }
  }
}
```

`data` 関数は任意のリアクティブな依存関係を追跡していないため、`store.state.message` への静的な参照だけを取得してます。ステートが後で変異したとき、コンポーネントは何かが変化しときのアイデアを持っていません。比較して、算出プロパティはそれらが評価されたときリアクティブな依存関係を全て追跡し、関連するステートが変異されているとき、反応性を再評価します。

### コンポーネントは直接ステートを変異することはできない

読み取り専用の算出プロパティを使用すると、**コンポーネントは直接 Vuex store のステートを変異させるべきではない**というルールを強調するのを援助するという別の利点を持っています。全てのステートのミューテーションを明示的および追跡可能にしたいため、全ての vuex store のミューテーションは store のミューテーションハンドラ内部で行われければなりません。

このルールを強制するのを援助するために、[厳格モード](strict.md) で store のステートがミューテーションハンドラの外部で変異された場合は、Vuex はエラーを投げます。

代わりにこのルールでは、私達の Vue コンポーネントははるかに少ない責務で済みます。読み取り専用の算出プロパティを介して Vuex store のステートにバインドされており、ステートに影響を与えるための唯一の方法は、**アクション**によって呼び出され、順番に**ミューテーション** をトリガすることです。必要であれば、まだ所有しローカルステートに操作できますが、もはや個々のコンポーネント内部には、任意のデータフェッチまたはグローバルステートミューテーティングロジックを入れていません。
