/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.redis.impl.shareddata;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Counter;
import java.util.concurrent.CompletionStage;
import org.redisson.api.RAtomicLong;

public class RedisCounter
implements Counter {
    private final Vertx vertx;
    private final RAtomicLong counter;

    public RedisCounter(Vertx vertx, RAtomicLong counter) {
        this.vertx = vertx;
        this.counter = counter;
    }

    public Future<Long> get() {
        return Future.fromCompletionStage((CompletionStage)this.counter.getAsync(), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Long> incrementAndGet() {
        return Future.fromCompletionStage((CompletionStage)this.counter.incrementAndGetAsync(), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Long> getAndIncrement() {
        return Future.fromCompletionStage((CompletionStage)this.counter.getAndIncrementAsync(), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Long> decrementAndGet() {
        return Future.fromCompletionStage((CompletionStage)this.counter.decrementAndGetAsync(), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Long> addAndGet(long value) {
        return Future.fromCompletionStage((CompletionStage)this.counter.addAndGetAsync(value), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Long> getAndAdd(long value) {
        return Future.fromCompletionStage((CompletionStage)this.counter.getAndAddAsync(value), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Boolean> compareAndSet(long expected, long value) {
        return Future.fromCompletionStage((CompletionStage)this.counter.compareAndSetAsync(expected, value), (Context)this.vertx.getOrCreateContext());
    }
}

