/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.redis.impl.shareddata;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.AsyncMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RMapCache;

public class RedisAsyncMap<K, V>
implements AsyncMap<K, V> {
    private final Vertx vertx;
    private final RMapCache<K, V> map;

    public RedisAsyncMap(Vertx vertx, RMapCache<K, V> map) {
        this.vertx = vertx;
        this.map = map;
    }

    public Future<V> get(K k) {
        return Future.fromCompletionStage((CompletionStage)this.map.getAsync(k), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Void> put(K k, V v) {
        return Future.fromCompletionStage((CompletionStage)this.map.putAsync(k, v), (Context)this.vertx.getOrCreateContext()).map(result -> null);
    }

    public Future<Void> put(K k, V v, long ttl) {
        return Future.fromCompletionStage((CompletionStage)this.map.putAsync(k, v, ttl, TimeUnit.MILLISECONDS), (Context)this.vertx.getOrCreateContext()).map(result -> null);
    }

    public Future<V> putIfAbsent(K k, V v) {
        return Future.fromCompletionStage((CompletionStage)this.map.putIfAbsentAsync(k, v), (Context)this.vertx.getOrCreateContext());
    }

    public Future<V> putIfAbsent(K k, V v, long ttl) {
        return Future.fromCompletionStage((CompletionStage)this.map.putIfAbsentAsync(k, v, ttl, TimeUnit.MILLISECONDS), (Context)this.vertx.getOrCreateContext());
    }

    public Future<V> remove(K k) {
        return Future.fromCompletionStage((CompletionStage)this.map.removeAsync(k), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Boolean> removeIfPresent(K k, V v) {
        return Future.fromCompletionStage((CompletionStage)this.map.removeAsync(k, v), (Context)this.vertx.getOrCreateContext());
    }

    public Future<V> replace(K k, V v) {
        return Future.fromCompletionStage((CompletionStage)this.map.replaceAsync(k, v), (Context)this.vertx.getOrCreateContext());
    }

    private CompletionStage<Boolean> updateTimeToLive(K k, long ttl) {
        return this.map.updateEntryExpirationAsync(k, ttl, TimeUnit.MILLISECONDS, 0L, TimeUnit.MILLISECONDS);
    }

    private <R> CompletionStage<R> succeededWith(R value) {
        return Future.succeededFuture(value).toCompletionStage();
    }

    public Future<V> replace(K k, V v, long ttl) {
        return Future.fromCompletionStage((CompletionStage)this.map.replaceAsync(k, v).thenCompose(result -> {
            if (result != null) {
                return this.updateTimeToLive(k, ttl).thenCompose(b -> this.succeededWith(result));
            }
            return this.succeededWith(null);
        }), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue) {
        return Future.fromCompletionStage((CompletionStage)this.map.replaceAsync(k, oldValue, newValue), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue, long ttl) {
        return Future.fromCompletionStage((CompletionStage)this.map.replaceAsync(k, oldValue, newValue).thenCompose(result -> {
            if (Boolean.TRUE.equals(result)) {
                return this.updateTimeToLive(k, ttl).thenCompose(b -> this.succeededWith(true));
            }
            return this.succeededWith(false);
        }), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Void> clear() {
        return Future.fromCompletionStage((CompletionStage)this.map.deleteAsync(), (Context)this.vertx.getOrCreateContext()).map(result -> null);
    }

    public Future<Integer> size() {
        return Future.fromCompletionStage((CompletionStage)this.map.sizeAsync(), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Set<K>> keys() {
        return Future.fromCompletionStage((CompletionStage)this.map.readAllKeySetAsync(), (Context)this.vertx.getOrCreateContext());
    }

    public Future<List<V>> values() {
        return Future.fromCompletionStage((CompletionStage)this.map.readAllValuesAsync(), (Context)this.vertx.getOrCreateContext()).map(v -> v instanceof List ? (List)v : new ArrayList(v));
    }

    public Future<Map<K, V>> entries() {
        return Future.fromCompletionStage((CompletionStage)this.map.readAllMapAsync(), (Context)this.vertx.getOrCreateContext());
    }
}

