/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.redis.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.spi.cluster.redis.impl.codec.BooleanCodec;
import io.vertx.spi.cluster.redis.impl.codec.ClassLoaderCodec;
import io.vertx.spi.cluster.redis.impl.codec.ClusterSerializableCodec;
import io.vertx.spi.cluster.redis.impl.codec.NullCodec;
import java.io.IOException;
import java.io.Serializable;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.IntegerCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.SerializationCodec;

public class RedisMapCodec
extends ClassLoaderCodec {
    private final Decoder<Object> decoder = (buf, state) -> {
        Codec codec = ValueCodec.forEncoded(buf, this.getClassLoader());
        return codec.getValueDecoder().decode(buf, state);
    };
    private final Encoder encoder = in -> {
        ValueCodec vc = ValueCodec.forObject(in);
        ByteBuf header = ByteBufAllocator.DEFAULT.buffer().writeInt(vc.id);
        ByteBuf payload = vc.codec.getValueEncoder().encode(in);
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{header, payload});
    };

    public RedisMapCodec() {
    }

    public RedisMapCodec(ClassLoader classLoader) {
        super(classLoader);
    }

    public RedisMapCodec(ClassLoader classLoader, RedisMapCodec codec) {
        this(classLoader);
    }

    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    public Encoder getValueEncoder() {
        return this.encoder;
    }

    private static enum ValueCodec {
        STRING(String.class, (Codec)StringCodec.INSTANCE, 0),
        INTEGER(Integer.class, (Codec)IntegerCodec.INSTANCE, 1),
        BOOLEAN(Boolean.class, BooleanCodec.INSTANCE, 2),
        VERTX(ClusterSerializable.class, ClusterSerializableCodec.INSTANCE, 3),
        JDK(Serializable.class, (Codec)new SerializationCodec(), 4),
        NULL(Void.class, NullCodec.INSTANCE, 5);

        private final Class<?> type;
        private final Codec codec;
        private final int id;

        private ValueCodec(Class<?> type, Codec codec, int id) {
            this.type = type;
            this.codec = codec;
            this.id = id;
        }

        static ValueCodec forObject(Object value) {
            if (value == null) {
                return NULL;
            }
            for (ValueCodec codec : ValueCodec.values()) {
                if (!codec.type.isAssignableFrom(value.getClass())) continue;
                return codec;
            }
            throw new IllegalArgumentException("No Codec found for type:" + value.getClass().getName());
        }

        static Codec forEncoded(ByteBuf buf, ClassLoader classLoader) throws IOException {
            int id = buf.readInt();
            for (ValueCodec codec : ValueCodec.values()) {
                if (codec.id != id) continue;
                try {
                    return BaseCodec.copy((ClassLoader)classLoader, (Codec)codec.codec);
                }
                catch (ReflectiveOperationException e) {
                    throw new IOException("Failed to copy Codec " + codec.codec.getClass().getName(), e);
                }
            }
            throw new IllegalArgumentException("No Codec found for id:" + id);
        }
    }
}

