/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.redis.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.spi.cluster.redis.impl.codec.ClassLoaderCodec;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class ClusterSerializableCodec
extends ClassLoaderCodec {
    public static final Codec INSTANCE = new ClusterSerializableCodec();
    private final Decoder<Object> decoder = (buf, state) -> {
        int classNameLength = buf.readInt();
        String className = buf.readCharSequence(classNameLength, StandardCharsets.UTF_8).toString();
        try {
            Object object = this.getClassLoader().loadClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(object instanceof ClusterSerializable)) {
                throw new IOException(className + " does not implement " + ClusterSerializable.class.getName());
            }
            ((ClusterSerializable)object).readFromBuffer(buf.readerIndex(), Buffer.buffer((ByteBuf)buf));
            return object;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Failed to decode class " + className, e);
        }
    };
    private final Encoder encoder = in -> {
        if (!(in instanceof ClusterSerializable)) {
            throw new IOException("Unsupported type: " + in.getClass());
        }
        ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
        String className = in.getClass().getName();
        out.writeInt(className.length());
        out.writeCharSequence((CharSequence)className, StandardCharsets.UTF_8);
        ((ClusterSerializable)in).writeToBuffer(Buffer.buffer((ByteBuf)out));
        return out;
    };

    public ClusterSerializableCodec() {
    }

    public ClusterSerializableCodec(ClassLoader classLoader) {
        super(classLoader);
    }

    public ClusterSerializableCodec(ClassLoader classLoader, ClusterSerializableCodec codec) {
        this(classLoader);
    }

    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

