/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.redis.impl;

import io.vertx.core.Vertx;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.core.spi.cluster.RegistrationUpdateEvent;
import io.vertx.spi.cluster.redis.impl.RedisKeyFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.redisson.api.RSetMultimap;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionCatalog {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionCatalog.class);
    private final Vertx vertx;
    private final RSetMultimap<String, RegistrationInfo> subsMap;
    private final NodeSelector nodeSelector;
    private final int listenerId;
    private final RTopic topic;
    private final ConcurrentMap<String, Set<RegistrationInfo>> localSubs = new ConcurrentHashMap<String, Set<RegistrationInfo>>();
    private final ConcurrentMap<String, Set<RegistrationInfo>> ownSubs = new ConcurrentHashMap<String, Set<RegistrationInfo>>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public SubscriptionCatalog(Vertx vertx, RedissonClient redisson, RedisKeyFactory keyFactory, NodeSelector nodeSelector) {
        this.vertx = vertx;
        this.nodeSelector = nodeSelector;
        this.subsMap = redisson.getSetMultimap(keyFactory.vertx("subs"));
        this.topic = redisson.getTopic(keyFactory.topic("subs"));
        this.listenerId = this.topic.addListener(String.class, this::onMessage);
    }

    private void onMessage(CharSequence channel, String address) {
        log.trace("Address [{}] updated", (Object)address);
        this.fireRegistrationUpdateEvent(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RegistrationInfo> get(String address) {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            ArrayList<RegistrationInfo> result;
            Set remote = this.subsMap.getAll((Object)address);
            Set local = this.localSubs.getOrDefault(address, Collections.emptySet());
            if (!local.isEmpty()) {
                result = new ArrayList(local.size() + remote.size());
                result.addAll(local);
            } else {
                result = new ArrayList<RegistrationInfo>(remote.size());
            }
            result.addAll(remote);
            ArrayList<RegistrationInfo> arrayList = result;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String address, RegistrationInfo registrationInfo) {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            if (registrationInfo.localOnly()) {
                this.localSubs.compute(address, (k, v) -> this.addToSet(registrationInfo, (Set<RegistrationInfo>)v));
                this.fireRegistrationUpdateEvent(address);
            } else {
                this.ownSubs.compute(address, (k, v) -> this.addToSet(registrationInfo, (Set<RegistrationInfo>)v));
                this.subsMap.put((Object)address, (Object)registrationInfo);
                this.topic.publish((Object)address);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void fireRegistrationUpdateEvent(String address) {
        this.vertx.executeBlocking(promise -> {
            if (this.nodeSelector.wantsUpdatesFor(address)) {
                List<Object> registrationInfos;
                try {
                    registrationInfos = this.get(address);
                }
                catch (Exception e) {
                    log.trace("A failure occurred while retrieving the updated registrations", (Throwable)e);
                    registrationInfos = Collections.emptyList();
                }
                this.nodeSelector.registrationsUpdated(new RegistrationUpdateEvent(address, registrationInfos));
            }
            promise.complete();
        });
    }

    private Set<RegistrationInfo> addToSet(RegistrationInfo registrationInfo, Set<RegistrationInfo> value) {
        Set<RegistrationInfo> newValue = value != null ? value : ConcurrentHashMap.newKeySet();
        newValue.add(registrationInfo);
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String address, RegistrationInfo registrationInfo) {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            if (registrationInfo.localOnly()) {
                this.localSubs.computeIfPresent(address, (k, v) -> this.removeFromSet(registrationInfo, (Set<RegistrationInfo>)v));
                this.fireRegistrationUpdateEvent(address);
            } else {
                this.ownSubs.computeIfPresent(address, (k, v) -> this.removeFromSet(registrationInfo, (Set<RegistrationInfo>)v));
                this.subsMap.remove((Object)address, (Object)registrationInfo);
                this.topic.publish((Object)address);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private Set<RegistrationInfo> removeFromSet(RegistrationInfo registrationInfo, Set<RegistrationInfo> value) {
        value.remove(registrationInfo);
        return value.isEmpty() ? null : value;
    }

    public void removeAllForNodes(Set<String> nodeIds) {
        HashSet updated = new HashSet();
        this.subsMap.entries().forEach(entry -> {
            if (nodeIds.contains(((RegistrationInfo)entry.getValue()).nodeId())) {
                this.subsMap.remove(entry.getKey(), entry.getValue());
                updated.add((String)entry.getKey());
            }
        });
        updated.forEach(arg_0 -> ((RTopic)this.topic).publish(arg_0));
    }

    public void republishOwnSubs() {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            HashSet updated = new HashSet();
            this.ownSubs.forEach((address, registrationInfos) -> registrationInfos.forEach(registrationInfo -> {
                this.subsMap.put(address, registrationInfo);
                updated.add(address);
            }));
            updated.forEach(arg_0 -> ((RTopic)this.topic).publish(arg_0));
        }
        finally {
            writeLock.unlock();
        }
    }

    public void close() {
        this.topic.removeListener(new Integer[]{this.listenerId});
    }
}

