/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.redis.impl;

public class RedisKeyFactory {
    private static final String VERTX = "__vertx";
    private static final String DELIMITER = ":";
    private final String namespace;
    private final boolean hasNamespace;

    public RedisKeyFactory(String namespace) {
        this.namespace = namespace;
        this.hasNamespace = namespace != null && !namespace.isEmpty();
    }

    private String build(String ... path) {
        String name = String.join((CharSequence)DELIMITER, path);
        return this.hasNamespace ? this.namespace + DELIMITER + name : name;
    }

    public String map(String name) {
        return this.build(name);
    }

    public String lock(String name) {
        return this.build(VERTX, "locks", name);
    }

    public String counter(String name) {
        return this.build(VERTX, "counters", name);
    }

    String topic(String name) {
        return this.build(VERTX, "topics", name);
    }

    String vertx(String name) {
        return this.build(VERTX, name);
    }
}

