/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.redis.impl;

import io.vertx.core.Vertx;
import io.vertx.core.spi.cluster.NodeInfo;
import io.vertx.spi.cluster.redis.impl.NodeInfoCatalogListener;
import io.vertx.spi.cluster.redis.impl.RedisKeyFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.redisson.api.map.event.EntryCreatedListener;
import org.redisson.api.map.event.EntryExpiredListener;
import org.redisson.api.map.event.EntryRemovedListener;
import org.redisson.api.map.event.MapEntryListener;

public class NodeInfoCatalog {
    private static final int TTL_SECONDS = 30;
    private final RMapCache<String, NodeInfo> nodeInfoMap;
    private final Vertx vertx;
    private final String nodeId;
    private final List<Integer> listenerIds = new ArrayList<Integer>();
    private final long timerId;

    public NodeInfoCatalog(Vertx vertx, RedissonClient redisson, RedisKeyFactory keyFactory, String nodeId, NodeInfoCatalogListener listener) {
        this.vertx = vertx;
        this.nodeId = nodeId;
        this.nodeInfoMap = redisson.getMapCache(keyFactory.vertx("nodeInfo"));
        EntryCreatedListener entryCreated = event -> listener.memberAdded((String)event.getKey());
        EntryRemovedListener entryRemoved = event -> listener.memberRemoved((String)event.getKey());
        EntryExpiredListener entryExpired = event -> listener.memberRemoved((String)event.getKey());
        this.listenerIds.add(this.nodeInfoMap.addListener((MapEntryListener)entryCreated));
        this.listenerIds.add(this.nodeInfoMap.addListener((MapEntryListener)entryRemoved));
        this.listenerIds.add(this.nodeInfoMap.addListener((MapEntryListener)entryExpired));
        this.timerId = vertx.setPeriodic(TimeUnit.SECONDS.toMillis(15L), this::keepNodeAlive);
    }

    private void keepNodeAlive(Long timerId) {
        this.nodeInfoMap.updateEntryExpirationAsync((Object)this.nodeId, 30L, TimeUnit.SECONDS, 0L, TimeUnit.MILLISECONDS);
    }

    public NodeInfo get(String nodeId) {
        return (NodeInfo)this.nodeInfoMap.get((Object)nodeId);
    }

    public void setNodeInfo(NodeInfo nodeInfo) {
        this.nodeInfoMap.fastPut((Object)this.nodeId, (Object)nodeInfo, 30L, TimeUnit.SECONDS);
    }

    public void remove(String nodeId) {
        this.nodeInfoMap.fastRemove((Object[])new String[]{nodeId});
    }

    public List<String> getNodes() {
        return new ArrayList<String>(this.nodeInfoMap.readAllKeySet());
    }

    public void close() {
        this.listenerIds.forEach(arg_0 -> this.nodeInfoMap.removeListener(arg_0));
        this.vertx.cancelTimer(this.timerId);
    }

    public String toString() {
        return this.nodeInfoMap.values().stream().map(NodeInfo::toString).collect(Collectors.joining("\n"));
    }
}

