/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.redis.config;

import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RedisConfigProps {
    private static final Logger log = LoggerFactory.getLogger(RedisConfigProps.class);

    private RedisConfigProps() {
    }

    static String getPropertyValue(String propertyName) {
        String envName = propertyName.replace(".", "_").toUpperCase();
        return System.getProperty(propertyName, System.getenv(envName));
    }

    static String getPropertyValue(String propertyName, String defaultValue) {
        String value = RedisConfigProps.getPropertyValue(propertyName);
        return value == null ? defaultValue : value;
    }

    static URI getDefaultEndpoint() {
        String scheme = RedisConfigProps.getPropertyValue("redis.connection.scheme", "redis");
        String host = RedisConfigProps.getPropertyValue("redis.connection.host", "127.0.0.1");
        String port = RedisConfigProps.getPropertyValue("redis.connection.port", "6379");
        String defaultAddress = scheme + "://" + host + ":" + port;
        String address = RedisConfigProps.getPropertyValue("redis.connection.address", defaultAddress);
        log.debug("Redis endpoint: [{}]", (Object)address);
        return URI.create(address);
    }
}

