/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.redis.config;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.spi.cluster.redis.config.ClientType;
import io.vertx.spi.cluster.redis.config.LockConfig;
import io.vertx.spi.cluster.redis.config.MapConfig;
import io.vertx.spi.cluster.redis.config.RedisConfig;
import java.util.Base64;
import java.util.Map;

public class RedisConfigConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, RedisConfig obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "clientType": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClientType(ClientType.valueOf((String)member.getValue()));
                    break;
                }
                case "endpoints": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addEndpoint((String)item);
                        }
                    });
                    break;
                }
                case "keyNamespace": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setKeyNamespace((String)member.getValue());
                    break;
                }
                case "locks": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            obj.addLock(new LockConfig((JsonObject)item));
                        }
                    });
                    break;
                }
                case "maps": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            obj.addMap(new MapConfig((JsonObject)item));
                        }
                    });
                }
            }
        }
    }

    public static void toJson(RedisConfig obj, JsonObject json) {
        RedisConfigConverter.toJson(obj, json.getMap());
    }

    public static void toJson(RedisConfig obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getClientType() != null) {
            json.put("clientType", obj.getClientType().name());
        }
        if (obj.getEndpoints() != null) {
            array = new JsonArray();
            obj.getEndpoints().forEach(item -> array.add(item));
            json.put("endpoints", array);
        }
        if (obj.getKeyNamespace() != null) {
            json.put("keyNamespace", obj.getKeyNamespace());
        }
        if (obj.getLocks() != null) {
            array = new JsonArray();
            obj.getLocks().forEach(item -> array.add((Object)item.toJson()));
            json.put("locks", array);
        }
        if (obj.getMaps() != null) {
            array = new JsonArray();
            obj.getMaps().forEach(item -> array.add((Object)item.toJson()));
            json.put("maps", array);
        }
    }
}

