/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.redis.config;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonObject;
import io.vertx.spi.cluster.redis.config.ClientType;
import io.vertx.spi.cluster.redis.config.KeyConfig;
import io.vertx.spi.cluster.redis.config.LockConfig;
import io.vertx.spi.cluster.redis.config.MapConfig;
import io.vertx.spi.cluster.redis.config.RedisConfigConverter;
import io.vertx.spi.cluster.redis.config.RedisConfigProps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@DataObject(generateConverter=true)
public class RedisConfig {
    private ClientType type = ClientType.STANDALONE;
    private String keyNamespace;
    private final String defaultEndpoint;
    private List<String> endpoints = new ArrayList<String>();
    private final List<MapConfig> maps = new ArrayList<MapConfig>();
    private final List<LockConfig> locks = new ArrayList<LockConfig>();

    public RedisConfig() {
        this.defaultEndpoint = RedisConfigProps.getDefaultEndpoint().toASCIIString();
        this.keyNamespace = RedisConfigProps.getPropertyValue("redis.key.namespace");
    }

    public RedisConfig(RedisConfig other) {
        this.defaultEndpoint = other.defaultEndpoint;
        this.type = other.type;
        this.keyNamespace = other.keyNamespace;
        this.endpoints = new ArrayList<String>(other.endpoints);
        other.maps.stream().map(MapConfig::new).forEach(this.maps::add);
        other.locks.stream().map(LockConfig::new).forEach(this.locks::add);
    }

    public RedisConfig(JsonObject json) {
        this();
        RedisConfigConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public RedisConfig setKeyNamespace(String keyNamespace) {
        this.keyNamespace = keyNamespace;
        return this;
    }

    public String getKeyNamespace() {
        return this.keyNamespace == null ? "" : this.keyNamespace;
    }

    public RedisConfig setClientType(ClientType type) {
        this.type = type;
        return this;
    }

    public ClientType getClientType() {
        return this.type == null ? ClientType.STANDALONE : this.type;
    }

    public RedisConfig addEndpoint(String redisUrl) {
        try {
            new URI(redisUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal redis URL", e);
        }
        this.endpoints.add(redisUrl);
        return this;
    }

    public List<String> getEndpoints() {
        if (this.endpoints == null || this.endpoints.isEmpty()) {
            return Collections.singletonList(this.defaultEndpoint);
        }
        if (this.type == ClientType.STANDALONE) {
            return Collections.singletonList(this.endpoints.get(0));
        }
        return Collections.unmodifiableList(this.endpoints);
    }

    public RedisConfig addMap(MapConfig mapConfig) {
        this.maps.add(mapConfig);
        return this;
    }

    public List<MapConfig> getMaps() {
        return Collections.unmodifiableList(this.maps);
    }

    public List<LockConfig> getLocks() {
        return Collections.unmodifiableList(this.locks);
    }

    public RedisConfig addLock(LockConfig lockConfig) {
        this.locks.add(lockConfig);
        return this;
    }

    private <T extends KeyConfig<?>> Optional<T> findConfig(List<T> list, String name) {
        if (list == null || list.isEmpty()) {
            return Optional.empty();
        }
        return list.stream().filter(opt -> opt.matches(name)).findFirst();
    }

    @GenIgnore
    public Optional<MapConfig> getMapConfig(String name) {
        return this.findConfig(this.maps, name);
    }

    @GenIgnore
    public Optional<LockConfig> getLockConfig(String name) {
        return this.findConfig(this.locks, name);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RedisConfigConverter.toJson(this, json);
        return json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisConfig that = (RedisConfig)o;
        return this.type == that.type && Objects.equals(this.keyNamespace, that.keyNamespace) && this.defaultEndpoint.equals(that.defaultEndpoint) && this.endpoints.equals(that.endpoints) && this.maps.equals(that.maps) && this.locks.equals(that.locks);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.keyNamespace, this.defaultEndpoint, this.endpoints, this.maps, this.locks});
    }

    public String toString() {
        return this.toJson().encodePrettily();
    }
}

