/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.redis.config;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.spi.cluster.redis.config.EvictionMode;
import io.vertx.spi.cluster.redis.config.KeyConfig;
import io.vertx.spi.cluster.redis.config.MapConfigConverter;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

@DataObject(generateConverter=true)
public final class MapConfig
extends KeyConfig {
    private int maxSize = 0;
    private EvictionMode evictionMode = EvictionMode.LRU;

    public MapConfig(String name) {
        super(name);
    }

    public MapConfig(Pattern pattern) {
        super(pattern);
    }

    public MapConfig(MapConfig other) {
        super(other);
        this.evictionMode = other.evictionMode;
        this.maxSize = other.maxSize;
    }

    public MapConfig(JsonObject json) {
        MapConfigConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public MapConfig setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public MapConfig setEvictionMode(EvictionMode evictionMode) {
        this.evictionMode = evictionMode;
        return this;
    }

    public EvictionMode getEvictionMode() {
        if (this.evictionMode == null) {
            return EvictionMode.LRU;
        }
        return this.evictionMode;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        MapConfigConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        return String.format("maxSize=%d, evictionMode=%s", new Object[]{this.maxSize, this.getEvictionMode()});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MapConfig mapConfig = (MapConfig)o;
        return this.maxSize == mapConfig.maxSize && this.evictionMode == mapConfig.evictionMode;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.maxSize, this.evictionMode});
    }
}

