/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.redis.config;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import java.util.Objects;
import java.util.regex.Pattern;

abstract class KeyConfig<T extends KeyConfig<T>> {
    private String name;
    private String pattern;
    @GenIgnore
    private Pattern regex;

    KeyConfig() {
    }

    KeyConfig(String name) {
        this.name = name;
    }

    KeyConfig(Pattern pattern) {
        this.regex = pattern;
        this.pattern = pattern.pattern();
    }

    KeyConfig(KeyConfig<T> other) {
        this.name = other.name;
        this.pattern = other.pattern;
        this.regex = other.regex;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public T setPattern(String pattern) {
        this.pattern = pattern;
        this.regex = Pattern.compile(pattern);
        return (T)this;
    }

    public T setName(String name) {
        this.name = name;
        return (T)this;
    }

    public @Nullable String getPattern() {
        return this.pattern;
    }

    public boolean matches(String name) {
        if (this.name == null && this.pattern == null) {
            return false;
        }
        if (this.name != null) {
            return this.name.equals(name);
        }
        return this.regex.matcher(name).matches();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyConfig keyConfig = (KeyConfig)o;
        return Objects.equals(this.name, keyConfig.name) && Objects.equals(this.pattern, keyConfig.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.pattern);
    }
}

