/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.redis;

import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeInfo;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.spi.cluster.redis.RedisInstance;
import io.vertx.spi.cluster.redis.config.ClientType;
import io.vertx.spi.cluster.redis.config.LockConfig;
import io.vertx.spi.cluster.redis.config.RedisConfig;
import io.vertx.spi.cluster.redis.impl.NodeInfoCatalog;
import io.vertx.spi.cluster.redis.impl.NodeInfoCatalogListener;
import io.vertx.spi.cluster.redis.impl.RedisKeyFactory;
import io.vertx.spi.cluster.redis.impl.RedissonRedisInstance;
import io.vertx.spi.cluster.redis.impl.SubscriptionCatalog;
import io.vertx.spi.cluster.redis.impl.codec.RedisMapCodec;
import io.vertx.spi.cluster.redis.impl.shareddata.RedisAsyncMap;
import io.vertx.spi.cluster.redis.impl.shareddata.RedisCounter;
import io.vertx.spi.cluster.redis.impl.shareddata.RedisLock;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.Redisson;
import org.redisson.api.EvictionMode;
import org.redisson.api.RMapCache;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RSemaphore;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisClusterManager
implements ClusterManager,
NodeInfoCatalogListener {
    private static final Logger log = LoggerFactory.getLogger(RedisClusterManager.class);
    private VertxInternal vertx;
    private NodeSelector nodeSelector;
    private UUID nodeId;
    private NodeInfo nodeInfo;
    private NodeListener nodeListener;
    private final AtomicBoolean active = new AtomicBoolean();
    private final RedisConfig config;
    private final Config redisConfig;
    private final RedisKeyFactory keyFactory;
    private RedissonClient redisson;
    private NodeInfoCatalog nodeInfoCatalog;
    private SubscriptionCatalog subscriptionCatalog;
    private ExecutorService lockReleaseExec;
    private final ConcurrentMap<String, AsyncMap<?, ?>> asyncMapCache = new ConcurrentHashMap();
    private final ConcurrentMap<String, SemaphoreWrapper> locksCache = new ConcurrentHashMap<String, SemaphoreWrapper>();

    public RedisClusterManager() {
        this(new RedisConfig());
    }

    public RedisClusterManager(RedisConfig config) {
        this(config, RedisClusterManager.class.getClassLoader());
    }

    public RedisClusterManager(RedisConfig config, ClassLoader dataClassLoader) {
        Objects.requireNonNull(dataClassLoader);
        this.redisConfig = new Config();
        if (config.getClientType() != ClientType.STANDALONE) {
            throw new IllegalStateException("RedisClusterManager only supports STANDALONE client");
        }
        this.redisConfig.useSingleServer().setAddress(config.getEndpoints().get(0));
        this.redisConfig.setCodec((Codec)new RedisMapCodec(dataClassLoader));
        if (dataClassLoader != this.getClass().getClassLoader()) {
            this.redisConfig.setUseThreadClassLoader(false);
        }
        this.keyFactory = new RedisKeyFactory(config.getKeyNamespace());
        this.config = new RedisConfig(config);
    }

    public void init(Vertx vertx, NodeSelector nodeSelector) {
        this.vertx = (VertxInternal)vertx;
        this.nodeSelector = nodeSelector;
    }

    private <K, V> RMapCache<K, V> getMapCache(String name) {
        RMapCache map = this.redisson.getMapCache(this.keyFactory.map(name));
        log.debug("Create map '{}'", (Object)name);
        this.config.getMapConfig(name).ifPresent(mapConfig -> {
            log.debug("Configure map '{}' with {}", (Object)name, mapConfig);
            map.setMaxSize(mapConfig.getMaxSize(), EvictionMode.valueOf((String)mapConfig.getEvictionMode().name()));
        });
        return map;
    }

    public <K, V> void getAsyncMap(String name, Promise<AsyncMap<K, V>> promise) {
        AsyncMap map = this.asyncMapCache.computeIfAbsent(name, key -> new RedisAsyncMap((Vertx)this.vertx, this.getMapCache((String)key)));
        promise.complete((Object)map);
    }

    public <K, V> Map<K, V> getSyncMap(String name) {
        return this.getMapCache(name);
    }

    private SemaphoreWrapper createSemaphore(String name) {
        int leaseTime = this.config.getLockConfig(name).map(LockConfig::getLeaseTime).orElse(-1);
        if (leaseTime == -1) {
            log.debug("Create semaphore '{}'", (Object)name);
            RSemaphore semaphore = this.redisson.getSemaphore(this.keyFactory.lock(name));
            semaphore.trySetPermits(1);
            return new SemaphoreWrapper(semaphore);
        }
        log.debug("Create semaphore '{}' with leaseTime={}", (Object)name, (Object)leaseTime);
        RPermitExpirableSemaphore semaphore = this.redisson.getPermitExpirableSemaphore(this.keyFactory.lock(name));
        semaphore.trySetPermits(1);
        return new SemaphoreWrapper(semaphore, leaseTime);
    }

    public void getLockWithTimeout(String name, long timeout, Promise<Lock> promise) {
        this.vertx.executeBlocking(prom -> {
            long start;
            RedisLock lock;
            SemaphoreWrapper semaphore = this.locksCache.computeIfAbsent(name, this::createSemaphore);
            long remaining = timeout;
            do {
                start = System.nanoTime();
                try {
                    lock = semaphore.tryAcquire(remaining, this.lockReleaseExec);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new VertxException("Interrupted while waiting for lock.", (Throwable)e);
                }
            } while (lock == null && (remaining -= TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS)) > 0L);
            if (lock == null) {
                throw new VertxException("Timed out waiting to get lock " + name);
            }
            prom.complete((Object)lock);
        }, false, promise);
    }

    public void getCounter(String name, Promise<Counter> promise) {
        promise.complete((Object)new RedisCounter((Vertx)this.vertx, this.redisson.getAtomicLong(this.keyFactory.counter(name))));
    }

    public String getNodeId() {
        return this.nodeId.toString();
    }

    public List<String> getNodes() {
        return this.nodeInfoCatalog.getNodes();
    }

    public void nodeListener(NodeListener listener) {
        this.nodeListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeInfo(NodeInfo nodeInfo, Promise<Void> promise) {
        RedisClusterManager redisClusterManager = this;
        synchronized (redisClusterManager) {
            this.nodeInfo = nodeInfo;
        }
        this.vertx.executeBlocking(prom -> {
            this.nodeInfoCatalog.setNodeInfo(nodeInfo);
            prom.complete();
        }, false, promise);
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public void getNodeInfo(String nodeId, Promise<NodeInfo> promise) {
        this.vertx.executeBlocking(prom -> {
            NodeInfo value = this.nodeInfoCatalog.get(nodeId);
            if (value != null) {
                prom.complete((Object)value);
            } else {
                prom.fail("Not a member of the cluster");
            }
        }, false, promise);
    }

    public void join(Promise<Void> promise) {
        this.vertx.executeBlocking(prom -> {
            if (this.active.compareAndSet(false, true)) {
                this.nodeId = UUID.randomUUID();
                this.lockReleaseExec = Executors.newCachedThreadPool(r -> new Thread(r, "vertx-redis-service-release-lock-thread"));
                this.redisson = Redisson.create((Config)this.redisConfig);
                this.nodeInfoCatalog = new NodeInfoCatalog((Vertx)this.vertx, this.redisson, this.keyFactory, this.nodeId.toString(), this);
                this.subscriptionCatalog = new SubscriptionCatalog((Vertx)this.vertx, this.redisson, this.keyFactory, this.nodeSelector);
            } else {
                log.warn("Already activated, nodeId: {}", (Object)this.nodeId);
            }
            prom.complete();
        }, promise);
    }

    @Override
    public void memberAdded(String nodeId) {
        if (this.isActive()) {
            log.debug("Add member [{}]", (Object)nodeId);
            if (this.nodeListener != null) {
                this.nodeListener.nodeAdded(nodeId);
            }
            log.debug("Nodes in catalog:\n{}", (Object)this.nodeInfoCatalog);
        }
    }

    @Override
    public void memberRemoved(String nodeId) {
        if (this.isActive()) {
            log.debug("Remove member [{}]", (Object)nodeId);
            this.subscriptionCatalog.removeAllForNodes(Collections.singleton(nodeId));
            this.nodeInfoCatalog.remove(nodeId);
            log.debug("Nodes in catalog:\n{}", (Object)this.nodeInfoCatalog);
            this.nodeInfoCatalog.setNodeInfo(this.getNodeInfo());
            this.nodeSelector.registrationsLost();
            this.vertx.executeBlocking(prom -> {
                this.subscriptionCatalog.republishOwnSubs();
                prom.complete();
            }, false);
            if (this.nodeListener != null) {
                this.nodeListener.nodeLeft(nodeId);
            }
        }
    }

    public void leave(Promise<Void> promise) {
        this.vertx.executeBlocking(prom -> {
            if (this.active.compareAndSet(true, false)) {
                try {
                    this.lockReleaseExec.shutdown();
                    this.subscriptionCatalog.close();
                    this.nodeInfoCatalog.close();
                    this.subscriptionCatalog.removeAllForNodes(Collections.singleton(this.nodeId.toString()));
                    this.nodeInfoCatalog.remove(this.nodeId.toString());
                    this.redisson.shutdown();
                    this.redisson = null;
                }
                catch (Exception e) {
                    prom.fail((Throwable)e);
                }
            } else {
                log.warn("Already deactivated, nodeId: {}", (Object)this.nodeId);
            }
            prom.complete();
        }, promise);
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void addRegistration(String address, RegistrationInfo registrationInfo, Promise<Void> promise) {
        this.vertx.executeBlocking(prom -> {
            this.subscriptionCatalog.put(address, registrationInfo);
            prom.complete();
        }, false, promise);
    }

    public void removeRegistration(String address, RegistrationInfo registrationInfo, Promise<Void> promise) {
        this.vertx.executeBlocking(prom -> {
            this.subscriptionCatalog.remove(address, registrationInfo);
            prom.complete();
        }, false, promise);
    }

    public void getRegistrations(String address, Promise<List<RegistrationInfo>> promise) {
        this.vertx.executeBlocking(prom -> prom.complete(this.subscriptionCatalog.get(address)), false, promise);
    }

    public Optional<RedisInstance> getRedisInstance() {
        if (!this.isActive()) {
            return Optional.empty();
        }
        return Optional.of(new RedissonRedisInstance(this.redisson, this.config));
    }

    private static class SemaphoreWrapper {
        private RPermitExpirableSemaphore permitSemaphore;
        private RSemaphore semaphore;
        private int leaseTime;

        private SemaphoreWrapper(RSemaphore semaphore) {
            this.semaphore = semaphore;
        }

        private SemaphoreWrapper(RPermitExpirableSemaphore semaphore, int leaseTime) {
            this.permitSemaphore = semaphore;
            this.leaseTime = leaseTime;
        }

        public RedisLock tryAcquire(long waitTime, ExecutorService lockReleaseExec) throws InterruptedException {
            RedisLock lock = null;
            if (this.semaphore != null) {
                if (this.semaphore.tryAcquire(waitTime, TimeUnit.MILLISECONDS)) {
                    lock = new RedisLock(this.semaphore, lockReleaseExec);
                }
            } else {
                String permitId = this.permitSemaphore.tryAcquire(waitTime, (long)this.leaseTime, TimeUnit.MILLISECONDS);
                if (permitId != null) {
                    lock = new RedisLock(this.permitSemaphore, permitId, lockReleaseExec);
                }
            }
            return lock;
        }
    }
}

