/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.redis;

import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.ext.healthchecks.Status;
import io.vertx.spi.cluster.redis.RedisClusterManager;
import io.vertx.spi.cluster.redis.RedisInstance;
import java.util.Objects;

public interface ClusterHealthCheck {
    public static Handler<Promise<Status>> createProcedure(Vertx vertx) {
        Objects.requireNonNull(vertx);
        return healthCheckPromise -> vertx.executeBlocking(promise -> {
            VertxInternal vertxInternal = (VertxInternal)Vertx.currentContext().owner();
            RedisClusterManager clusterManager = (RedisClusterManager)vertxInternal.getClusterManager();
            boolean connected = clusterManager.getRedisInstance().map(RedisInstance::ping).orElse(false);
            promise.complete((Object)new Status().setOk(connected));
        }, false, (Handler)healthCheckPromise);
    }
}

