qt_add_library(${MODULE} STATIC)

set_target_properties(${MODULE} PROPERTIES AUTOMOC ON)

qt_add_qml_module(${MODULE}
    URI ScratchCPP.${MODULE_URI}
    VERSION 1.0
    OUTPUT_DIRECTORY ${CMAKE_CURRENT_BINARY_DIR}/ScratchCPP/${MODULE_URI}
    QML_FILES
        ${MODULE_QML_FILES}
    RESOURCES
        ${MODULE_RESOURCES}
    SOURCES
        ${MODULE_SRC}
)

set(QML_IMPORT_PATH "${QML_IMPORT_PATH};${CMAKE_CURRENT_LIST_DIR}"
    CACHE STRING "Qt Creator extra QML import paths"
    FORCE
)

target_link_libraries(${MODULE} PRIVATE ${QT_LIBS})
target_include_directories(${MODULE} PRIVATE ${PROJECT_SOURCE_DIR}/src)
target_include_directories(${MODULE} PRIVATE ${PROJECT_SOURCE_DIR}/src/global)

list(APPEND QML_IMPORT_PATH ${CMAKE_CURRENT_SOURCE_DIR} ${CMAKE_CURRENT_BINARY_DIR})
list(REMOVE_DUPLICATES QML_IMPORT_PATH)
set(QML_IMPORT_PATH ${QML_IMPORT_PATH} CACHE STRING "" FORCE)

target_link_libraries(${APP_TARGET} PRIVATE ${MODULE} ${MODULE}plugin)
set(MODULE_SRC_DIR ${CMAKE_CURRENT_SOURCE_DIR})
