package tech.httptoolkit.javaagent

import java.io.File
import java.io.FileInputStream
import java.security.KeyStore
import java.security.cert.Certificate
import java.security.cert.CertificateFactory
import javax.net.ssl.SSLContext
import javax.net.ssl.TrustManagerFactory

fun buildTrustManagerFactoryForCertificate(certPath: String): TrustManagerFactory {
    val certFile = File(certPath)
    val certificate: Certificate = CertificateFactory.getInstance("X.509")
        .generateCertificate(FileInputStream(certFile))

    val keyStore = KeyStore.getInstance(KeyStore.getDefaultType())
    keyStore.load(null, null)
    keyStore.setCertificateEntry("proxy-https-CA", certificate)

    val trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm())
    trustManagerFactory.init(keyStore)
    return trustManagerFactory
}

fun buildSslContextForCertificate(trustManagerFactory: TrustManagerFactory): SSLContext {
    val sslContext = SSLContext.getInstance("TLS")
    sslContext.init(null, trustManagerFactory.trustManagers, null)
    return sslContext
}