# Learning with lis.py

This repository contains variations of Peter Norvig's
[`lis.py` interpreter](https://github.com/norvig/pytudes/blob/c33cd6835a506a57d9fe73e3a8317d49babb13e8/py/lis.py)
for a subset of [Scheme](https://en.wikipedia.org/wiki/Scheme_(programming_language)),
described in his post [(How to Write a (Lisp) Interpreter (in Python))](https://norvig.com/lispy.html).


## Provenance, Copyright and License

`lis.py` is
[published](https://github.com/norvig/pytudes/blob/c33cd6835a506a57d9fe73e3a8317d49babb13e8/py/lis.py)
in the [norvig/pytudes](https://github.com/norvig/pytudes) repository on Github.
The copyright holder is Peter Norvig and the code is licensed under the
[MIT license](https://github.com/norvig/pytudes/blob/60168bce8cdfacf57c92a5b2979f0b2e95367753/LICENSE).

Unless otherwise noted, I wrote the changes and additions described in the README files in each directory.

## References

### Articles

* Norvig, Peter: [(How to Write a (Lisp) Interpreter (in Python))](https://norvig.com/lispy.html)
* Norvig, Peter: [(An ((Even Better) Lisp) Interpreter (in Python))](https://norvig.com/lispy2.html)
* Graham, Paul: [The Roots of Lisp](http://www.paulgraham.com/rootsoflisp.html)
* Steele, Guy Lewis, Jr.; Sussman, Gerald Jay: [The Art of the Interpreter, or the Modularity Complex](https://dspace.mit.edu/handle/1721.1/6094)
* McCarthy, John: [Recursive functions of symbolic expressions and their computation by machine, Part I](https://dl.acm.org/doi/abs/10.1145/367177.367199) 🔒

### Books

* Abelson, Harold; Sussman, Gerald Jay; Sussman, Julie: [Structure and Interpretation of Computer Programs, Second Edition](https://mitpress.mit.edu/sites/default/files/sicp/index.html) (SICP)
* Dybvig, R. Kent: [The Scheme Programming Language, Fourth Edition](https://scheme.com/tspl4/) (TSPL)
* Harvey, Brian; Wright, Matthew: [Simply Scheme: Introducing Computer Science, Second Edition](https://people.eecs.berkeley.edu/~bh/ss-toc2.html)
* Friedman, Daniel P.; Felleisen, Matthias: [The Little Schemer, Fourth Edition](https://mitpress.mit.edu/books/little-schemer-fourth-edition) 🔒
* Butterick, Mathew: [Beautiful Racket—an introduction to language-oriented programming using Racket](https://beautifulracket.com/)
* Felleisen, Matthias; Findler, Robert Bruce; Flatt, Matthew; Krishnamurthi, Shriram: [How to Design Programs, Second Edition](https://htdp.org/)
* Krishnamurthi, Shriram: [Programming Languages: Application and Interpretation](https://www.plai.org/) (PLAI)
* Sperber, Michael; et. al. [Revised<sup>6</sup> Report on the Algorithmic Language Scheme](http://www.r6rs.org/) (R<sup>6</sup>RS)

### Interpreters and tools

* [Racket](https://racket-lang.org/): "the Language-Oriented Programming Language"
* [GNU Guile](https://www.gnu.org/software/guile/): "GNU Ubiquitous Intelligent Language for Extensions"
* [Chicken Scheme](https://www.call-cc.org/): "a practical and portable Scheme system"
* [A Meta-Circular Interpreter for Scheme](https://scheme.com/tspl4/examples.html#./examples:h7): example 12.7 from TSPL
* [McCarthy's original Lisp](references/jmc.lisp) converted to Common Lisp by Paul Graham ([local copy](references/jmc.lisp), [original download](https://sep.yimg.com/ty/cdn/paulgraham/jmc.lisp?t=1595850613))


*Luciano Ramalho*<br/>
São Paulo, August 23, 2021
