;;; $Id: hooks.scm,v 1.1 1994/08/25 10:22:34 queinnec Exp $

;;;(((((((((((((((((((((((((((((((( L i S P ))))))))))))))))))))))))))))))))
;;; This file is part of the files that accompany the book:
;;;     LISP Implantation Semantique Programmation (InterEditions, France)
;;; By Christian Queinnec <Christian.Queinnec@INRIA.fr>
;;; Newest version may be retrieved from:
;;;   (IP 128.93.2.54) ftp.inria.fr:INRIA/Projects/icsla/Books/LiSP*.tar.gz
;;; Check the README file before using this file.
;;;(((((((((((((((((((((((((((((((( L i S P ))))))))))))))))))))))))))))))))

;;; hooks.ss
;;; Robert Hieb & Kent Dybvig
;;; 92/06/18

;;;       adapted for SCM by Christian Queinnec

(define eval-hook eval)

(define expand-install-hook 
  (lambda (expand)
    (error-hook 'expand-install-hook "Not implemented" 34) ) )

;;; In Chez Scheme, the following reports:
;;;           "Error in <who>: <why> <what>."
;;; "who" is a symbol, "why" is a string, and "what" is an arbitrary object.

(define error-hook error)

;;; New symbols are used to generate non-capturing bindings.  If it is
;;; impossible to generate unique symbols, output identifiers during
;;; expansion and either feed the result directly into the compiler or
;;; make another pass to perform alpha substitution.

(define new-symbol-hook 
  (lambda (x) (gentemp)) )

;;; "put-global-definition-hook" should overwrite existing definitions.

(define *syntax-case-macros* '())

(define put-global-definition-hook
   (lambda (symbol binding)
     (let ((pair (assq symbol *syntax-case-macros*)))
       (if pair
           (set-cdr! pair binding)
           (set! *syntax-case-macros* 
                 (cons (cons symbol binding) *syntax-case-macros*) ) ) ) ) )

;;; "get-global-definition-hook" should return "#f" if no binding
;;; has been established "put-global-definition-hook" for the symbol.

(define get-global-definition-hook
   (lambda (symbol)
     (let ((pair (assq symbol *syntax-case-macros*)))
       (and pair (cdr pair)) ) ) )

;;; This function may be generated by syntax-case.scm

(define (list* . args)
  (if (pair? args)
      (if (pair? (cdr args))
          (cons (car args) (apply list* (cdr args)))
          (car args) )
      (quote ()) ) )

;;; end of hooks.scm
