---
layout: layouts/default
title: Resources
menu-order: 5
---

## Culori extras

These projects add more functionality to Culori, but they're separate as to keep the core bundle small:

-   [culori-scales](https://github.com/evercoder/culori-scales) — color scales (ColorBrewer, matplotlib, etc).
-   [culori-names](https://github.com/evercoder/culori-names) — More named colors, from a variety of sources.
-   [d3-color-difference](https://github.com/evercoder/d3-color-difference) — a separate D3.js plugin to compute color differences

## Products using Culori

-   [Moqups](https://moqups.com) — all our color-manipulation functions are handled by Culori.
-   [Schemist](https://github.com/felixgirault/schemist) — color schemes builder backed by Culori.
-   [Color Name API](https://github.com/meodai/color-name-api) — a REST API for color names that makes use Culori's [differenceCiede2000](https://culorijs.org/api/#differenceCiede2000) to return a fitting name for every color.

Does your product/project use Culori? Create a PR and add yourself to this list.

## Similar projects

JavaScript libraries:

-   [d3-color](https://github.com/d3/d3-color) by [Mike Bostock](https://bost.ocks.org/mike/)
-   [chroma.js](https://github.com/gka/chroma.js) by [Gregor Aisch](https://driven-by-data.net/)
-   [colorjs.io](https://github.com/LeaVerou/color.js) by [Lea Verou](http://lea.verou.me/) and [Chris Lilley](https://svgees.us/)

In other languages:

-   [Colour](https://www.colour-science.org/) for Python
-   [the `colorspace` package](http://colorspace.r-forge.r-project.org/) for R
-   [the `Colors` package](https://github.com/JuliaGraphics/Colors.jl) for Julia
- [ColorAide](https://github.com/facelessuser/coloraide) for Python by Isaac Muse
-   [colorio](https://github.com/nschloe/colorio) for Python by Nico Schlömer

## Further reading

### Specifications

- [CSS Color Level 4](https://drafts.csswg.org/css-color/)
- [CSS Color Level 5](https://drafts.csswg.org/css-color-5/)

### Websites

-   David Briggs's [The Dimensions of Color](http://www.huevaluechroma.com/)
-   Bruce Lindbloom's [Useful Color Math](http://www.brucelindbloom.com/index.html?Math.html)
-   Rune Madsen's [Programming Design Systems](https://programmingdesignsystems.com/)

### Articles

-   [Color: From Hexcodes to Eyeballs](http://jamie-wong.com/post/color/) by Jamie Wong

### Books

-   [Fairchild, Mark D.](http://markfairchild.org/) — [_Color Appearance Models_](https://www.wiley.com/en-us/Color+Appearance+Models%2C+3rd+Edition-p-9781119967033), 3rd Edition, Wiley, 2013.
- Morovič, Ján — [_Color Gamut Mapping_](https://www.wiley.com/en-ie/Color+Gamut+Mapping-p-9780470030325), Wiley, 2008.
-   [Poynton, Charles](http://poynton.ca/) — [_Digital Video and HD Algorithms and Interfaces_](https://www.elsevier.com/books/digital-video-and-hd/poynton/978-0-12-391926-7), 2nd Edition, Morgan Kaufmann, 2012.